/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DescriptorBasedMessageBusConnection
implements MessageBusImpl.MessageHandlerHolder {
    final PluginId pluginId;
    final Topic<?> topic;
    final List<Object> handlers;

    DescriptorBasedMessageBusConnection(@NotNull PluginId pluginId, @NotNull Topic<?> topic, @NotNull List<Object> handlers) {
        this.pluginId = pluginId;
        this.topic = topic;
        this.handlers = handlers;
    }

    @Override
    public void collectHandlers(@NotNull Topic<?> topic, @NotNull List<Object> result) {
        if (this.topic == topic) {
            result.addAll(this.handlers);
        }
    }

    @Override
    public void disconnectIfNeeded(@NotNull Predicate<Class<?>> predicate) {
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    public String toString() {
        return "DescriptorBasedMessageBusConnection(handlers=" + this.handlers + ')';
    }

    @Nullable
    static List<Object> computeNewHandlers(@NotNull List<Object> handlers, @NotNull Set<String> excludeClassNames) {
        ArrayList<Object> newHandlers = null;
        int size = handlers.size();
        for (int i = 0; i < size; ++i) {
            Object handler = handlers.get(i);
            if (excludeClassNames.contains(handler.getClass().getName())) {
                if (newHandlers != null) continue;
                newHandlers = i == 0 ? new ArrayList<Object>() : new ArrayList<Object>(handlers.subList(0, i));
                continue;
            }
            if (newHandlers == null) continue;
            newHandlers.add(handler);
        }
        return newHandlers;
    }
}

