/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RequestBuilder {
    public abstract RequestBuilder connectTimeout(int var1);

    public abstract RequestBuilder readTimeout(int var1);

    public abstract RequestBuilder redirectLimit(int var1);

    public abstract RequestBuilder gzip(boolean var1);

    public abstract RequestBuilder forceHttps(boolean var1);

    public abstract RequestBuilder useProxy(boolean var1);

    public abstract RequestBuilder hostNameVerifier(@Nullable HostnameVerifier var1);

    public abstract RequestBuilder userAgent(@Nullable String var1);

    public abstract RequestBuilder productNameAsUserAgent();

    public abstract RequestBuilder accept(@Nullable String var1);

    public abstract RequestBuilder tuner(@Nullable HttpRequests.ConnectionTuner var1);

    public abstract RequestBuilder isReadResponseOnError(boolean var1);

    @NotNull
    public abstract RequestBuilder throwStatusCodeException(boolean var1);

    public abstract <T> T connect(@NotNull HttpRequests.RequestProcessor<T> var1) throws IOException;

    public int tryConnect() throws IOException {
        return this.connect(request -> {
            URLConnection connection = request.getConnection();
            return connection instanceof HttpURLConnection ? ((HttpURLConnection)connection).getResponseCode() : -1;
        });
    }

    public <T> T connect(@NotNull HttpRequests.RequestProcessor<T> processor, T errorValue, @Nullable Logger logger) {
        try {
            return this.connect(processor);
        }
        catch (Throwable e) {
            if (logger != null) {
                logger.warn(e);
            }
            return errorValue;
        }
    }

    public void saveToFile(@NotNull File file, @Nullable ProgressIndicator indicator) throws IOException {
        this.connect(request -> request.saveToFile(file, indicator));
    }

    public byte @NotNull [] readBytes(@Nullable ProgressIndicator indicator) throws IOException {
        return this.connect(request -> request.readBytes(indicator));
    }

    @NotNull
    public String readString(@Nullable ProgressIndicator indicator) throws IOException {
        return this.connect(request -> request.readString(indicator));
    }

    @NotNull
    public String readString() throws IOException {
        return this.readString(null);
    }

    @NotNull
    public CharSequence readChars(@Nullable ProgressIndicator indicator) throws IOException {
        return this.connect(request -> request.readChars(indicator));
    }

    @NotNull
    public CharSequence readChars() throws IOException {
        return this.readChars(null);
    }

    public void write(@NotNull String data) throws IOException {
        this.connect(request -> {
            request.write(data);
            return null;
        });
    }

    public void write(byte @NotNull [] data) throws IOException {
        this.connect(request -> {
            request.write(data);
            return null;
        });
    }
}

