/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexableFileSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileBasedIndex {
    @Deprecated
    public static final boolean ourEnableTracingOfKeyHashToVirtualFileMapping = true;
    @ApiStatus.Internal
    public static final boolean ourSnapshotMappingsEnabled = SystemProperties.getBooleanProperty((String)"idea.index.snapshot.mappings.enabled", (boolean)true);
    private static final boolean ourDisableIndexAccessDuringDumbMode = SystemProperties.getBooleanProperty((String)"idea.disable.index.access.during.dumb.mode", (boolean)false);
    @ApiStatus.Internal
    public static final boolean USE_IN_MEMORY_INDEX = SystemProperties.is((String)"idea.use.in.memory.file.based.index");
    @ApiStatus.Internal
    public static final boolean IGNORE_PLAIN_TEXT_FILES = SystemProperties.is((String)"idea.ignore.plain.text.indexing");

    public abstract void iterateIndexableFiles(@NotNull ContentIterator var1, @NotNull Project var2, @Nullable ProgressIndicator var3);

    @Nullable
    public abstract VirtualFile getFileBeingCurrentlyIndexed();

    @ApiStatus.Internal
    @Nullable
    public DumbModeAccessType getCurrentDumbModeAccessType() {
        throw new UnsupportedOperationException();
    }

    public abstract void registerIndexableSet(@NotNull IndexableFileSet var1, @Nullable Project var2);

    public abstract void removeIndexableSet(@NotNull IndexableFileSet var1);

    public static FileBasedIndex getInstance() {
        return (FileBasedIndex)ApplicationManager.getApplication().getService(FileBasedIndex.class);
    }

    public static int getFileId(@NotNull VirtualFile file) {
        if (file instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)((Object)file)).getId();
        }
        throw new IllegalArgumentException("Virtual file doesn't support id: " + file + ", implementation class: " + file.getClass().getName());
    }

    @Deprecated
    public abstract VirtualFile findFileById(Project var1, int var2);

    public void requestRebuild(@NotNull ID<?, ?> indexId) {
        this.requestRebuild(indexId, new Throwable());
    }

    @NotNull
    public abstract <K, V> List<V> getValues(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    @NotNull
    public abstract <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    public abstract <K, V> boolean processValues(@NotNull ID<K, V> var1, @NotNull K var2, @Nullable VirtualFile var3, @NotNull ValueProcessor<? super V> var4, @NotNull GlobalSearchScope var5);

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull ValueProcessor<? super V> processor, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        return this.processValues(indexId, dataKey, inFile, processor, filter);
    }

    public abstract <K, V> long getIndexModificationStamp(@NotNull ID<K, V> var1, @NotNull Project var2);

    public abstract <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> var1, @NotNull Collection<? extends K> var2, @NotNull GlobalSearchScope var3, @Nullable Condition<? super V> var4, @NotNull Processor<? super VirtualFile> var5);

    @NotNull
    public abstract <K> Collection<K> getAllKeys(@NotNull ID<K, ?> var1, @NotNull Project var2);

    @ApiStatus.Internal
    public abstract <K> void ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3);

    public abstract void requestRebuild(@NotNull ID<?, ?> var1, @NotNull Throwable var2);

    public abstract <K> void scheduleRebuild(@NotNull ID<K, ?> var1, @NotNull Throwable var2);

    public abstract void requestReindex(@NotNull VirtualFile var1);

    public abstract <K, V> boolean getFilesWithKey(@NotNull ID<K, V> var1, @NotNull Set<? extends K> var2, @NotNull Processor<? super VirtualFile> var3, @NotNull GlobalSearchScope var4);

    @ApiStatus.Experimental
    public void ignoreDumbMode(@NotNull Runnable command, @NotNull DumbModeAccessType dumbModeAccessType) {
        this.ignoreDumbMode(dumbModeAccessType, () -> {
            command.run();
            return null;
        });
    }

    @ApiStatus.Experimental
    public <T, E extends Throwable> T ignoreDumbMode(@NotNull DumbModeAccessType dumbModeAccessType, @NotNull ThrowableComputable<T, E> computable) throws E {
        throw new UnsupportedOperationException();
    }

    public abstract <K> boolean processAllKeys(@NotNull ID<K, ?> var1, @NotNull Processor<? super K> var2, @Nullable Project var3);

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        return this.processAllKeys(indexId, processor, scope.getProject());
    }

    @NotNull
    public abstract <K, V> Map<K, V> getFileData(@NotNull ID<K, V> var1, @NotNull VirtualFile var2, @NotNull Project var3);

    public static void iterateRecursively(@NotNull VirtualFile root, @NotNull ContentIterator processor, @Nullable ProgressIndicator indicator, @Nullable Set<? super VirtualFile> visitedRoots, @Nullable ProjectFileIndex projectFileIndex) {
        VirtualFileFilter acceptFilter = file -> {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (visitedRoots != null && !root.equals(file) && file.isDirectory() && !visitedRoots.add(file)) {
                return false;
            }
            return projectFileIndex == null || (Boolean)ReadAction.compute(() -> projectFileIndex.isExcluded(file)) == false;
        };
        VirtualFileFilter symlinkFilter = file -> {
            if (acceptFilter.accept(file)) {
                if (file.is(VFileProperty.SYMLINK)) {
                    if (!Registry.is((String)"indexer.follows.symlinks")) {
                        return false;
                    }
                    VirtualFile canonicalFile = file.getCanonicalFile();
                    if (canonicalFile != null) {
                        return acceptFilter.accept(canonicalFile);
                    }
                }
                return true;
            }
            return false;
        };
        VfsUtilCore.iterateChildrenRecursively(root, symlinkFilter, processor);
    }

    public void invalidateCaches() {
        throw new IncorrectOperationException();
    }

    @ApiStatus.Internal
    public static boolean isIndexAccessDuringDumbModeEnabled() {
        return !ourDisableIndexAccessDuringDumbMode;
    }

    public static interface FileTypeSpecificInputFilter
    extends InputFilter {
        public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> var1);
    }

    @FunctionalInterface
    public static interface InputFilter {
        public boolean acceptInput(@NotNull VirtualFile var1);
    }

    @FunctionalInterface
    public static interface ValueProcessor<V> {
        public boolean process(@NotNull VirtualFile var1, V var2);
    }
}

