/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface CompositeDataIndexer<K, V, SubIndexerType, SubIndexerVersion>
extends DataIndexer<K, V, FileContent> {
    @Nullable
    public SubIndexerType calculateSubIndexer(@NotNull IndexedFile var1);

    default public boolean requiresContentForSubIndexerEvaluation(@NotNull IndexedFile file) {
        return false;
    }

    @NotNull
    public SubIndexerVersion getSubIndexerVersion(@NotNull SubIndexerType var1);

    @NotNull
    public KeyDescriptor<SubIndexerVersion> getSubIndexerVersionDescriptor();

    @NotNull
    default public Map<K, V> map(@NotNull FileContent inputData) {
        SubIndexerType subIndexerType = this.calculateSubIndexer(inputData);
        return subIndexerType == null ? Collections.emptyMap() : this.map(inputData, Objects.requireNonNull(subIndexerType));
    }

    @NotNull
    public Map<K, V> map(@NotNull FileContent var1, @NotNull SubIndexerType var2);
}

