/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WaitForProgressToShow {
    private WaitForProgressToShow() {
    }

    public static void runOrInvokeAndWaitAboveProgress(Runnable command) {
        WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(command, ModalityState.defaultModalityState());
    }

    public static void runOrInvokeAndWaitAboveProgress(Runnable command, @Nullable ModalityState modalityState) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            command.run();
        } else {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            if (pi != null) {
                WaitForProgressToShow.execute(pi);
                application.invokeAndWait(command);
            } else {
                ModalityState notNullModalityState = modalityState == null ? ModalityState.NON_MODAL : modalityState;
                application.invokeAndWait(command, notNullModalityState);
            }
        }
    }

    public static void runOrInvokeLaterAboveProgress(Runnable command, @Nullable ModalityState modalityState, @NotNull Project project) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            command.run();
        } else {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            if (pi != null) {
                WaitForProgressToShow.execute(pi);
                application.invokeLater(command, pi.getModalityState(), o -> !project.isOpen() || project.isDisposed());
            } else {
                ModalityState notNullModalityState = modalityState == null ? ModalityState.NON_MODAL : modalityState;
                application.invokeLater(command, notNullModalityState, project.getDisposed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(ProgressIndicator pi) {
        if (pi.isShowing()) {
            long maxWait = 3000L;
            long start = System.currentTimeMillis();
            while (!pi.isPopupWasShown() && pi.isRunning() && System.currentTimeMillis() - 3000L < start) {
                Object lock;
                Object object = lock = new Object();
                synchronized (object) {
                    try {
                        lock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ProgressManager.checkCanceled();
        }
    }
}

