/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.util.Condition;
import com.intellij.util.AbstractQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class FilteredQuery<T>
extends AbstractQuery<T> {
    private final Query<T> myOriginal;
    private final Condition<? super T> myFilter;

    public FilteredQuery(@NotNull Query<T> original, @NotNull Condition<? super T> filter) {
        this.myOriginal = original;
        this.myFilter = filter;
    }

    @Override
    protected boolean processResults(@NotNull Processor<? super T> consumer) {
        return FilteredQuery.delegateProcessResults(this.myOriginal, new MyProcessor(consumer));
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<? super T> consumer) {
        return this.myOriginal.forEachAsync(new MyProcessor(consumer));
    }

    private class MyProcessor
    implements Processor<T> {
        private final Processor<? super T> myConsumer;

        MyProcessor(Processor<? super T> consumer) {
            this.myConsumer = consumer;
        }

        public boolean process(T t) {
            return !FilteredQuery.this.myFilter.value(t) || this.myConsumer.process(t);
        }
    }
}

