/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Alarm
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(Alarm.class);
    private volatile boolean myDisposed;
    private final List<Request> myRequests = new SmartList();
    private final List<Request> myPendingRequests = new SmartList();
    private final ScheduledExecutorService myExecutorService;
    private final Object LOCK = new Object();
    private final ThreadToUse myThreadToUse;
    private JComponent myActivationComponent;

    public void dispose() {
        if (!this.myDisposed) {
            this.myDisposed = true;
            this.cancelAllRequests();
            if (this.myExecutorService != EdtExecutorService.getScheduledExecutorInstance()) {
                this.myExecutorService.shutdownNow();
            }
        }
    }

    private void checkDisposed() {
        LOG.assertTrue(!this.myDisposed, (Object)"Already disposed");
    }

    public Alarm() {
        this(ThreadToUse.SWING_THREAD);
    }

    public Alarm(@NotNull Disposable parentDisposable) {
        this(ThreadToUse.SWING_THREAD, parentDisposable);
    }

    public Alarm(@NotNull ThreadToUse threadToUse) {
        this(threadToUse, null);
    }

    public Alarm(@NotNull ThreadToUse threadToUse, @Nullable Disposable parentDisposable) {
        this.myThreadToUse = threadToUse;
        if (threadToUse == ThreadToUse.OWN_THREAD || threadToUse == ThreadToUse.SHARED_THREAD) {
            DeprecatedMethodException.report((String)"Please use POOLED_THREAD instead");
        }
        ScheduledExecutorService scheduledExecutorService = this.myExecutorService = threadToUse == ThreadToUse.SWING_THREAD ? EdtExecutorService.getScheduledExecutorInstance() : AppExecutorUtil.createBoundedScheduledExecutorService((String)"Alarm Pool", (int)1);
        if (parentDisposable == null) {
            if (threadToUse != ThreadToUse.SWING_THREAD) {
                LOG.error((Throwable)new IllegalArgumentException("You must provide parent Disposable for non-swing thread Alarm"));
            }
        } else {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    public void addRequest(final @NotNull Runnable request, final int delayMillis, boolean runWithActiveFrameOnly) {
        if (runWithActiveFrameOnly && !ApplicationManager.getApplication().isActive()) {
            MessageBus bus = ApplicationManager.getApplication().getMessageBus();
            final MessageBusConnection connection = bus.connect((Disposable)this);
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                @Override
                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    connection.disconnect();
                    Alarm.this.addRequest(request, delayMillis);
                }
            });
        } else {
            this.addRequest(request, delayMillis);
        }
    }

    private ModalityState getModalityState() {
        if (this.myThreadToUse != ThreadToUse.SWING_THREAD) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return null;
        }
        return application.getDefaultModalityState();
    }

    public void addRequest(@NotNull Runnable request, long delayMillis) {
        this._addRequest(request, delayMillis, this.getModalityState());
    }

    public void addRequest(@NotNull Runnable request, int delayMillis) {
        this._addRequest(request, delayMillis, this.getModalityState());
    }

    public void addComponentRequest(@NotNull Runnable request, int delayMillis) {
        assert (this.myActivationComponent != null);
        this._addRequest(request, delayMillis, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addComponentRequest(@NotNull Runnable request, long delayMillis) {
        assert (this.myActivationComponent != null);
        this._addRequest(request, delayMillis, ModalityState.stateForComponent(this.myActivationComponent));
    }

    public void addRequest(@NotNull Runnable request, int delayMillis, @Nullable ModalityState modalityState) {
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delayMillis, modalityState);
    }

    public void addRequest(@NotNull Runnable request, long delayMillis, @Nullable ModalityState modalityState) {
        LOG.assertTrue(this.myThreadToUse == ThreadToUse.SWING_THREAD);
        this._addRequest(request, delayMillis, modalityState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelAllAndAddRequest(@NotNull Runnable request, int delayMillis, @Nullable ModalityState modalityState) {
        Object object = this.LOCK;
        synchronized (object) {
            this.cancelAllRequests();
            this._addRequest(request, delayMillis, modalityState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addRequest(@NotNull Runnable request, long delayMillis, @Nullable ModalityState modalityState) {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkDisposed();
            Request requestToSchedule = new Request(request, modalityState, delayMillis);
            if (this.myActivationComponent == null || this.myActivationComponent.isShowing()) {
                this.add(requestToSchedule);
            } else if (!this.myPendingRequests.contains(requestToSchedule)) {
                this.myPendingRequests.add(requestToSchedule);
            }
        }
    }

    private void add(@NotNull Request requestToSchedule) {
        requestToSchedule.schedule();
        this.myRequests.add(requestToSchedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPending() {
        Object object = this.LOCK;
        synchronized (object) {
            for (Request each : this.myPendingRequests) {
                this.add(each);
            }
            this.myPendingRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelRequest(@NotNull Runnable request) {
        Object object = this.LOCK;
        synchronized (object) {
            this.cancelAndRemoveRequestFrom(request, this.myRequests);
            this.cancelAndRemoveRequestFrom(request, this.myPendingRequests);
            return true;
        }
    }

    private void cancelAndRemoveRequestFrom(@NotNull Runnable request, @NotNull List<? extends Request> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Request r = list.get(i);
            if (r.myTask != request) continue;
            r.cancel();
            list.remove(i);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelAllRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.cancelAllRequests(this.myRequests) + this.cancelAllRequests(this.myPendingRequests);
        }
    }

    private int cancelAllRequests(@NotNull List<? extends Request> list) {
        int count = list.size();
        for (Request request : list) {
            request.cancel();
        }
        list.clear();
        return count;
    }

    public void drainRequestsInTest() {
        for (Runnable task : this.getUnfinishedRequests()) {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<Runnable> getUnfinishedRequests() {
        ArrayList<Runnable> unfinishedTasks;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myRequests.isEmpty()) {
                return Collections.emptyList();
            }
            unfinishedTasks = new ArrayList<Runnable>(this.myRequests.size());
            for (Request request : this.myRequests) {
                Runnable existingTask = request.cancel();
                if (existingTask == null) continue;
                unfinishedTasks.add(existingTask);
            }
            this.myRequests.clear();
        }
        return unfinishedTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllExecuted(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Request> requests;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            requests = new ArrayList<Request>(this.myRequests);
        }
        for (Request request : requests) {
            Future future;
            Object object = this.LOCK;
            synchronized (object) {
                future = request.myFuture;
            }
            if (future == null) continue;
            future.get(timeout, unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveRequestCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRequests.isEmpty();
        }
    }

    @NotNull
    public Alarm setActivationComponent(@NotNull JComponent component) {
        this.myActivationComponent = component;
        new UiNotifyConnector(component, new Activatable(){

            @Override
            public void showNotify() {
                Alarm.this.flushPending();
            }
        });
        return this;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private class Request
    implements Runnable {
        private Runnable myTask;
        private final ModalityState myModalityState;
        private Future<?> myFuture;
        private final long myDelayMillis;
        private final ClientId myClientId;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Async.Schedule
        private Request(@Nullable Runnable task, ModalityState modalityState, long delayMillis) {
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                this.myTask = task;
                this.myModalityState = modalityState;
                this.myDelayMillis = delayMillis;
                this.myClientId = ClientId.getCurrent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable task;
                if (Alarm.this.myDisposed) {
                    return;
                }
                Object object = Alarm.this.LOCK;
                synchronized (object) {
                    task = this.myTask;
                    this.myTask = null;
                }
                if (task != null) {
                    this.runSafely(task);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Async.Execute
        private void runSafely(@Nullable Runnable task) {
            try {
                if (!Alarm.this.myDisposed && task != null) {
                    if (ClientId.Companion.getPropagateAcrossThreads()) {
                        ClientId.withClientId(this.myClientId, () -> QueueProcessor.runSafely((Runnable)task));
                    } else {
                        QueueProcessor.runSafely((Runnable)task);
                    }
                }
            }
            finally {
                Object object = Alarm.this.LOCK;
                synchronized (object) {
                    Alarm.this.myRequests.remove(this);
                    this.myFuture = null;
                }
            }
        }

        private void schedule() {
            this.myFuture = this.myModalityState == null ? Alarm.this.myExecutorService.schedule(this, this.myDelayMillis, TimeUnit.MILLISECONDS) : EdtScheduledExecutorService.getInstance().schedule((Runnable)this, this.myModalityState, this.myDelayMillis, TimeUnit.MILLISECONDS);
        }

        @Nullable
        private Runnable cancel() {
            Future<?> future = this.myFuture;
            if (future != null) {
                future.cancel(false);
                this.myFuture = null;
            }
            Runnable task = this.myTask;
            this.myTask = null;
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Runnable task;
            Object object = Alarm.this.LOCK;
            synchronized (object) {
                task = this.myTask;
            }
            return super.toString() + (task != null ? ": " + task : "");
        }
    }

    public static enum ThreadToUse {
        SWING_THREAD,
        SHARED_THREAD,
        POOLED_THREAD,
        OWN_THREAD;

    }
}

