/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageContextPanel;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageContextPanelBase;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.StatusText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsagePreviewPanel
extends UsageContextPanelBase
implements DataProvider {
    private static final Logger LOG = Logger.getInstance(UsagePreviewPanel.class);
    private Editor myEditor;
    private final boolean myIsEditor;
    private int myLineHeight;
    private List<? extends UsageInfo> myCachedSelectedUsageInfos;
    private Pattern myCachedSearchPattern = null;
    private Pattern myCachedReplacePattern = null;
    private static final Key<Boolean> IN_PREVIEW_USAGE_FLAG = Key.create((String)"IN_PREVIEW_USAGE_FLAG");
    private static final Key<Balloon> REPLACEMENT_BALLOON_KEY = Key.create((String)"REPLACEMENT_BALLOON_KEY");
    private static final Key<UsagePreviewPanel> PREVIEW_EDITOR_FLAG = Key.create((String)"PREVIEW_EDITOR_FLAG");

    public UsagePreviewPanel(@NotNull Project project, @NotNull UsageViewPresentation presentation) {
        this(project, presentation, false);
    }

    public UsagePreviewPanel(@NotNull Project project, @NotNull UsageViewPresentation presentation, boolean isEditor) {
        super(project, presentation);
        this.myIsEditor = isEditor;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (CommonDataKeys.EDITOR.is(dataId) && this.myEditor != null) {
            return this.myEditor;
        }
        if (Registry.is((String)"ide.find.preview.navigate.to.caret") && CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId) && this.myEditor instanceof EditorEx) {
            LogicalPosition position = this.myEditor.getCaretModel().getLogicalPosition();
            VirtualFile file = FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
            if (file != null) {
                return new Navigatable[]{new OpenFileDescriptor(this.myProject, file, position.line, position.column)};
            }
        }
        return null;
    }

    private void resetEditor(@NotNull List<? extends UsageInfo> infos) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiElement psiElement = infos.get(0).getElement();
        if (psiElement == null) {
            return;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance(this.myProject).getInjectionHost(psiFile);
        if (host != null && (psiFile = host.getContainingFile()) == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance(psiFile.getProject()).getDocument(psiFile);
        if (document == null) {
            return;
        }
        if (this.myEditor == null || document != this.myEditor.getDocument()) {
            this.releaseEditor();
            this.removeAll();
            this.myEditor = this.createEditor(psiFile, document);
            if (this.myEditor == null) {
                return;
            }
            this.myLineHeight = this.myEditor.getLineHeight();
            this.myEditor.setBorder(null);
            this.add(this.myEditor.getComponent(), "Center");
            this.invalidate();
            this.validate();
        }
        if (!(Comparing.equal(infos, this.myCachedSelectedUsageInfos) && UsageViewPresentation.arePatternsEqual(this.myCachedSearchPattern, this.myPresentation.getSearchPattern()) && UsageViewPresentation.arePatternsEqual(this.myCachedReplacePattern, this.myPresentation.getReplacePattern()))) {
            UsagePreviewPanel.highlight(infos, this.myEditor, this.myProject, true, 3000);
            this.myCachedSelectedUsageInfos = infos;
            this.myCachedSearchPattern = this.myPresentation.getSearchPattern();
            this.myCachedReplacePattern = this.myPresentation.getReplacePattern();
        }
    }

    public int getLineHeight() {
        return this.myLineHeight;
    }

    public static void highlight(@NotNull List<? extends UsageInfo> infos, @NotNull Editor editor, @NotNull Project project, boolean highlightOnlyNameElements, int highlightLayer) {
        LOG.assertTrue(PsiDocumentManager.getInstance(project).isCommitted(editor.getDocument()));
        MarkupModel markupModel = editor.getMarkupModel();
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            if (highlighter.getUserData(IN_PREVIEW_USAGE_FLAG) == null) continue;
            highlighter.dispose();
        }
        Balloon balloon = (Balloon)editor.getUserData(REPLACEMENT_BALLOON_KEY);
        if (balloon != null && !Disposer.isDisposed((Disposable)balloon)) {
            Disposer.dispose((Disposable)balloon);
            editor.putUserData(REPLACEMENT_BALLOON_KEY, null);
        }
        FindModel findModel = UsagePreviewPanel.getReplacementModel(editor);
        for (int i = infos.size() - 1; i >= 0; --i) {
            PsiFile psiFile;
            PsiElement nameElement;
            TextRange textRange;
            UsageInfo info = infos.get(i);
            PsiElement psiElement = info.getElement();
            if (psiElement == null || !psiElement.isValid()) continue;
            int offsetInFile = psiElement.getTextOffset();
            TextRange elementRange = psiElement.getTextRange();
            ProperTextRange infoRange = info.getRangeInElement();
            TextRange textRange2 = textRange = infoRange == null || infoRange.getStartOffset() > elementRange.getLength() || infoRange.getEndOffset() > elementRange.getLength() ? null : elementRange.cutOut((TextRange)infoRange);
            if (textRange == null) {
                textRange = elementRange;
            }
            if (highlightOnlyNameElements && psiElement instanceof PsiNamedElement && !(psiElement instanceof PsiFile) && (nameElement = (psiFile = psiElement.getContainingFile()).findElementAt(offsetInFile)) != null) {
                textRange = nameElement.getTextRange();
            }
            textRange = InjectedLanguageManager.getInstance(project).injectedToHost(psiElement, textRange);
            RangeHighlighter highlighter = markupModel.addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, textRange.getStartOffset(), textRange.getEndOffset(), highlightLayer, HighlighterTargetArea.EXACT_RANGE);
            highlighter.putUserData(IN_PREVIEW_USAGE_FLAG, Boolean.TRUE);
            if (infoRange != null && findModel != null && findModel.isReplaceState()) {
                RangeHighlighter boxHighlighter = markupModel.addRangeHighlighter(infoRange.getStartOffset(), infoRange.getEndOffset(), highlightLayer, new TextAttributes(null, null, editor.getColorsScheme().getColor(EditorColors.CARET_COLOR), EffectType.BOXED, 0), HighlighterTargetArea.EXACT_RANGE);
                boxHighlighter.putUserData(IN_PREVIEW_USAGE_FLAG, Boolean.TRUE);
                editor.getCaretModel().moveToOffset(infoRange.getEndOffset());
            } else {
                editor.getCaretModel().moveToOffset(textRange.getEndOffset());
            }
            if (findModel == null || infos.size() != 1 || infoRange == null || !infoRange.equals((Object)textRange)) continue;
            UsagePreviewPanel.showBalloon(project, editor, (TextRange)infoRange, findModel);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
    }

    private static void showBalloon(Project project, Editor editor, TextRange range, @NotNull FindModel findModel) {
        try {
            String replacementPreviewText = FindManager.getInstance(project).getStringToReplace(editor.getDocument().getText(range), findModel, range.getStartOffset(), editor.getDocument().getText());
            if (!Registry.is((String)"ide.find.show.replacement.hint.for.simple.regexp") && Objects.equals(replacementPreviewText, findModel.getStringToReplace())) {
                return;
            }
            ReplacementView replacementView = new ReplacementView(replacementPreviewText);
            BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder(replacementView);
            balloonBuilder.setFadeoutTime(0L);
            balloonBuilder.setFillColor(IdeTooltipManager.GRAPHITE_COLOR);
            balloonBuilder.setAnimationCycle(0);
            balloonBuilder.setHideOnClickOutside(false);
            balloonBuilder.setHideOnKeyOutside(false);
            balloonBuilder.setHideOnAction(false);
            balloonBuilder.setCloseButtonEnabled(true);
            Balloon balloon = balloonBuilder.createBalloon();
            EditorUtil.disposeWithEditor((Editor)editor, (Disposable)balloon);
            balloon.show(new ReplacementBalloonPositionTracker(project, editor, range, findModel), Balloon.Position.below);
            editor.putUserData(REPLACEMENT_BALLOON_KEY, balloon);
        }
        catch (FindManager.MalformedReplacementStringException malformedReplacementStringException) {
            // empty catch block
        }
    }

    @Nullable
    private static FindModel getReplacementModel(@NotNull Editor editor) {
        UsagePreviewPanel panel2 = (UsagePreviewPanel)editor.getUserData(PREVIEW_EDITOR_FLAG);
        Pattern searchPattern = null;
        Pattern replacePattern = null;
        if (panel2 != null) {
            searchPattern = panel2.myPresentation.getSearchPattern();
            replacePattern = panel2.myPresentation.getReplacePattern();
        }
        if (searchPattern == null || replacePattern == null) {
            return null;
        }
        FindModel stub = new FindModel();
        stub.setMultiline(true);
        stub.setRegularExpressions(true);
        stub.setReplaceAll(true);
        stub.setStringToFind(searchPattern.pattern());
        stub.setStringToReplace(replacePattern.pattern());
        return stub;
    }

    private Editor createEditor(PsiFile psiFile, Document document) {
        if (this.isDisposed) {
            return null;
        }
        Project project = psiFile.getProject();
        Editor editor = EditorFactory.getInstance().createEditor(document, project, psiFile.getVirtualFile(), !this.myIsEditor, this.getEditorKind());
        EditorSettings settings = editor.getSettings();
        this.customizeEditorSettings(settings);
        editor.putUserData(PREVIEW_EDITOR_FLAG, this);
        return editor;
    }

    @NotNull
    protected EditorKind getEditorKind() {
        return EditorKind.PREVIEW;
    }

    protected void customizeEditorSettings(EditorSettings settings) {
        settings.setLineMarkerAreaShown(this.myIsEditor);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setAnimatedScrolling(false);
        settings.setAutoCodeFoldingEnabled(false);
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
        this.releaseEditor();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (editor.getProject() != this.myProject || editor.getUserData(PREVIEW_EDITOR_FLAG) != this) continue;
            LOG.error("Editor was not released:" + editor);
        }
    }

    private void releaseEditor() {
        if (this.myEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
            this.myEditor = null;
            this.myCachedSelectedUsageInfos = null;
            this.myCachedSearchPattern = null;
            this.myCachedReplacePattern = null;
        }
    }

    @Nullable
    public final String getCannotPreviewMessage(@Nullable List<? extends UsageInfo> infos) {
        return this.cannotPreviewMessage(infos);
    }

    @Nullable
    private String cannotPreviewMessage(@Nullable List<? extends UsageInfo> infos) {
        if (infos == null || infos.isEmpty()) {
            return UsageViewBundle.message("select.the.usage.to.preview", this.myPresentation.getUsagesWord());
        }
        PsiFile psiFile = null;
        for (UsageInfo usageInfo : infos) {
            PsiFile file = usageInfo.getFile();
            if (psiFile == null) {
                psiFile = file;
                continue;
            }
            if (psiFile == file) continue;
            return UsageViewBundle.message("several.occurrences.selected", new Object[0]);
        }
        return null;
    }

    @Override
    public void updateLayoutLater(@Nullable List<? extends UsageInfo> infos) {
        String cannotPreviewMessage = this.cannotPreviewMessage(infos);
        if (cannotPreviewMessage != null) {
            this.releaseEditor();
            this.removeAll();
            int newLineIndex = cannotPreviewMessage.indexOf("\n");
            if (newLineIndex == -1) {
                this.getEmptyText().setText(cannotPreviewMessage);
            } else {
                this.getEmptyText().setText(cannotPreviewMessage.substring(0, newLineIndex)).appendSecondaryText(cannotPreviewMessage.substring(newLineIndex + 1), StatusText.DEFAULT_ATTRIBUTES, null);
            }
            this.revalidate();
        } else {
            this.resetEditor(infos);
        }
    }

    static boolean insideVisibleArea(Editor e, TextRange r) {
        int textLength = e.getDocument().getTextLength();
        if (r.getStartOffset() > textLength) {
            return false;
        }
        if (r.getEndOffset() > textLength) {
            return false;
        }
        Rectangle visibleArea = e.getScrollingModel().getVisibleArea();
        Point point = e.logicalPositionToXY(e.offsetToLogicalPosition(r.getStartOffset()));
        return visibleArea.contains(point);
    }

    private static class ReplacementBalloonPositionTracker
    extends PositionTracker<Balloon> {
        private final Project myProject;
        private final Editor myEditor;
        private final TextRange myRange;
        private final FindModel myFindModel;

        ReplacementBalloonPositionTracker(Project project, Editor editor, TextRange range, FindModel findModel) {
            super((Component)editor.getContentComponent());
            this.myProject = project;
            this.myEditor = editor;
            this.myRange = range;
            this.myFindModel = findModel;
        }

        public RelativePoint recalculateLocation(Balloon balloon) {
            int startOffset = this.myRange.getStartOffset();
            int endOffset = this.myRange.getEndOffset();
            if (!UsagePreviewPanel.insideVisibleArea(this.myEditor, this.myRange)) {
                if (!balloon.isDisposed()) {
                    Disposer.dispose((Disposable)balloon);
                }
                VisibleAreaListener visibleAreaListener = new VisibleAreaListener(){

                    @Override
                    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
                        if (UsagePreviewPanel.insideVisibleArea(myEditor, myRange)) {
                            UsagePreviewPanel.showBalloon(myProject, myEditor, myRange, myFindModel);
                            1 visibleAreaListener = this;
                            myEditor.getScrollingModel().removeVisibleAreaListener(visibleAreaListener);
                        }
                    }
                };
                this.myEditor.getScrollingModel().addVisibleAreaListener(visibleAreaListener);
            }
            Point startPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(startOffset));
            Point endPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(endOffset));
            Point point = new Point((startPoint.x + endPoint.x) / 2, startPoint.y + this.myEditor.getLineHeight());
            return new RelativePoint((Component)this.myEditor.getContentComponent(), point);
        }
    }

    private static class ReplacementView
    extends JPanel {
        private static final String MALFORMED_REPLACEMENT_STRING = "Malformed replacement string";

        @Override
        protected void paintComponent(@NotNull Graphics graphics) {
        }

        ReplacementView(@Nullable String replacement) {
            String textToShow = replacement;
            if (replacement == null) {
                textToShow = MALFORMED_REPLACEMENT_STRING;
            }
            JLabel jLabel = new JLabel(textToShow);
            jLabel.setForeground((Color)(replacement != null ? new JBColor((Color)Gray._240, (Color)Gray._200) : JBColor.RED));
            this.add(jLabel);
        }
    }

    public static class Provider
    implements UsageContextPanel.Provider {
        @Override
        @NotNull
        public UsageContextPanel create(@NotNull UsageView usageView) {
            return new UsagePreviewPanel(((UsageViewImpl)usageView).getProject(), usageView.getPresentation(), true);
        }

        @Override
        public boolean isAvailableFor(@NotNull UsageView usageView) {
            return true;
        }

        @Override
        @NotNull
        public String getTabTitle() {
            return UsageViewBundle.message("tab.title.preview", new Object[0]);
        }
    }
}

