/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.rules.ActiveRules;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProviderEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageGroupingRuleProviderImpl
implements UsageGroupingRuleProviderEx {
    protected boolean supportsNonCodeRule() {
        return true;
    }

    protected boolean supportsModuleRule() {
        return true;
    }

    protected boolean supportsScopesRule() {
        return true;
    }

    @Override
    public UsageGroupingRule @NotNull [] getActiveRules(@NotNull Project project) {
        return this.getActiveRules(project, UsageViewSettings.getInstance());
    }

    @Override
    public UsageGroupingRule @NotNull [] getActiveRules(@NotNull Project project, @NotNull UsageViewSettings usageViewSettings) {
        return ActiveRules.getActiveRules(project, usageViewSettings, this.supportsNonCodeRule(), this.supportsScopesRule(), this.supportsModuleRule());
    }

    @Override
    @NotNull
    public UsageGroupingRule[] getAllRules(@NotNull Project project, @Nullable UsageView usageView) {
        return ActiveRules.getAllRules(project, UsageViewSettings.getInstance(), this.supportsNonCodeRule(), this.supportsScopesRule(), this.supportsModuleRule());
    }

    @Override
    public AnAction @NotNull [] createGroupingActions(@NotNull UsageView view) {
        UsageViewImpl impl = (UsageViewImpl)view;
        AnAction groupByModuleTypeAction = this.supportsModuleRule() ? ActionManager.getInstance().getAction("UsageGrouping.Module") : null;
        GroupByFileStructureAction groupByFileStructureAction = UsageGroupingRuleProviderImpl.createGroupByFileStructureAction(impl);
        AnAction groupByDirectoryStructureAction = UsageGroupingRuleProviderImpl.createGroupByDirectoryStructureAction();
        AnAction groupByScopeAction = this.supportsScopesRule() ? ActionManager.getInstance().getAction("UsageGrouping.Scope") : null;
        AnAction groupByPackageAction = ActionManager.getInstance().getAction(DirectoryGroupingRule.getInstance(((UsageViewImpl)view).getProject()).getGroupingActionId());
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        if (view.getPresentation().isUsageTypeFilteringAvailable()) {
            AnAction groupByUsageTypeAction = ActionManager.getInstance().getAction("UsageGrouping.UsageType");
            ContainerUtil.addIfNotNull(result, (Object)groupByUsageTypeAction);
            ContainerUtil.addIfNotNull(result, (Object)groupByScopeAction);
            ContainerUtil.addIfNotNull(result, (Object)groupByModuleTypeAction);
            if (this.supportsModuleRule()) {
                AnAction flattenModulesAction = ActionManager.getInstance().getAction("UsageGrouping.FlattenModules");
                result.add(flattenModulesAction);
            }
            ContainerUtil.addIfNotNull(result, (Object)groupByPackageAction);
            ContainerUtil.addIfNotNull(result, (Object)groupByDirectoryStructureAction);
            ContainerUtil.addIfNotNull(result, (Object)groupByFileStructureAction);
        } else {
            ContainerUtil.addIfNotNull(result, (Object)groupByScopeAction);
            ContainerUtil.addIfNotNull(result, (Object)groupByModuleTypeAction);
            ContainerUtil.addIfNotNull(result, (Object)groupByPackageAction);
            ContainerUtil.addIfNotNull(result, (Object)groupByDirectoryStructureAction);
        }
        return result.toArray(AnAction.EMPTY_ARRAY);
    }

    @Deprecated
    @NotNull
    public static GroupByFileStructureAction createGroupByFileStructureAction(UsageViewImpl impl) {
        return (GroupByFileStructureAction)ActionManager.getInstance().getAction("UsageGrouping.FileStructure");
    }

    @NotNull
    private static AnAction createGroupByDirectoryStructureAction() {
        return ActionManager.getInstance().getAction("UsageGrouping.DirectoryStructure");
    }

    @ApiStatus.Internal
    public static class GroupByFileStructureAction
    extends com.intellij.usages.impl.actions.GroupByFileStructureAction {
    }
}

