/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupNode
extends Node
implements Navigatable,
Comparable<GroupNode> {
    private static final NodeComparator COMPARATOR = new NodeComparator();
    private final int myRuleIndex;
    private int myRecursiveUsageCount;
    private final List<Node> myChildren = new SmartList();

    private GroupNode(@NotNull Node parent, @NotNull UsageGroup group, int ruleIndex) {
        this.setUserObject(group);
        this.setParent(parent);
        this.myRuleIndex = ruleIndex;
    }

    private GroupNode() {
        this.myRuleIndex = 0;
    }

    @Override
    protected void updateNotify() {
        if (this.getGroup() != null) {
            this.getGroup().update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String result = this.getGroup() == null ? "" : this.getGroup().getText(null);
        GroupNode groupNode = this;
        synchronized (groupNode) {
            return result + ContainerUtil.getFirstItems(this.myChildren, (int)10);
        }
    }

    @NotNull
    List<Node> getChildren() {
        return this.myChildren;
    }

    @NotNull
    List<Node> getSwingChildren() {
        Vector children = this.children;
        return (List)ObjectUtils.notNull((Object)children, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    GroupNode addOrGetGroup(@NotNull UsageGroup group, int ruleIndex, @NotNull Consumer<? super Node> edtInsertedUnderQueue) {
        GroupNode newNode;
        GroupNode groupNode = this;
        synchronized (groupNode) {
            newNode = new GroupNode(this, group, ruleIndex);
            int i = GroupNode.getNodeIndex(newNode, this.myChildren);
            if (i >= 0) {
                return (GroupNode)this.myChildren.get(i);
            }
            int insertionIndex = -i - 1;
            this.myChildren.add(insertionIndex, newNode);
        }
        edtInsertedUnderQueue.consume((Object)this);
        return newNode;
    }

    private static int getNodeIndex(@NotNull Node newNode, @NotNull List<? extends Node> children) {
        return Collections.binarySearch(children, newNode, COMPARATOR);
    }

    private static int getNodeInsertionIndex(@NotNull Node node, @NotNull List<? extends Node> children) {
        int i = GroupNode.getNodeIndex(node, children);
        return i >= 0 ? i : -i - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTargetsNode(@NotNull Node node, @NotNull DefaultTreeModel treeModel) {
        int index;
        ApplicationManager.getApplication().assertIsDispatchThread();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            index = GroupNode.getNodeInsertionIndex(node, this.getSwingChildren());
            this.myChildren.add(index, node);
        }
        treeModel.insertNodeInto(node, this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllChildren() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.removeAllChildren();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            this.myChildren.clear();
        }
        this.myRecursiveUsageCount = 0;
    }

    @Nullable
    private UsageNode tryMerge(@NotNull Usage usage) {
        if (!(usage instanceof MergeableUsage)) {
            return null;
        }
        MergeableUsage mergeableUsage = (MergeableUsage)((Object)usage);
        for (UsageNode node : this.getUsageNodes()) {
            Usage original = node.getUsage();
            if (original == mergeableUsage) {
                return node;
            }
            if (!(original instanceof MergeableUsage) || !((MergeableUsage)((Object)original)).merge(mergeableUsage)) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeUsagesBulk(@NotNull Set<UsageNode> usages, @NotNull DefaultTreeModel treeModel) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        int removed = 0;
        GroupNode groupNode = this;
        synchronized (groupNode) {
            SmartList removedNodes = new SmartList();
            for (UsageNode usage : usages) {
                if (!this.myChildren.remove(usage)) continue;
                removedNodes.add(usage);
                ++removed;
            }
            if (removed == 0) {
                for (GroupNode groupNode2 : this.getSubGroups()) {
                    int delta = groupNode2.removeUsagesBulk(usages, treeModel);
                    if (delta <= 0) continue;
                    if (groupNode2.getRecursiveUsageCount() == 0) {
                        this.myChildren.remove(groupNode2);
                        removedNodes.add(groupNode2);
                    }
                    if ((removed += delta) != usages.size()) continue;
                    break;
                }
            }
            if (!this.myChildren.isEmpty()) {
                GroupNode.removeNodesFromParent(treeModel, this, (List<? extends MutableTreeNode>)removedNodes);
            }
        }
        if (removed > 0) {
            this.myRecursiveUsageCount -= removed;
            if (this.myRecursiveUsageCount != 0) {
                treeModel.nodeChanged(this);
            }
        }
        return removed;
    }

    /*
     * WARNING - void declaration
     */
    private static void removeNodesFromParent(@NotNull DefaultTreeModel treeModel, @NotNull GroupNode parent, @NotNull List<? extends MutableTreeNode> nodes) {
        void var6_8;
        int count = nodes.size();
        if (count == 0) {
            return;
        }
        ObjectIntHashMap ordering = new ObjectIntHashMap(count);
        for (MutableTreeNode mutableTreeNode : nodes) {
            ordering.put((Object)mutableTreeNode, parent.getIndex(mutableTreeNode));
        }
        nodes.sort(Comparator.comparingInt(arg_0 -> ((ObjectIntHashMap)ordering).get(arg_0)));
        int[] indices = ordering.getValues();
        Arrays.sort(indices);
        int n = count - 1;
        while (var6_8 >= 0) {
            parent.remove(indices[var6_8]);
            --var6_8;
        }
        treeModel.nodesWereRemoved(parent, indices, nodes.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    UsageNode addOrGetUsage(@NotNull Usage usage, boolean filterDuplicateLines, @NotNull Consumer<? super Node> edtInsertedUnderQueue) {
        UsageNode newNode;
        GroupNode groupNode = this;
        synchronized (groupNode) {
            UsageNode mergedWith;
            if (filterDuplicateLines && (mergedWith = this.tryMerge(usage)) != null) {
                return mergedWith;
            }
            newNode = new UsageNode(this, usage);
            int i = GroupNode.getNodeIndex(newNode, this.myChildren);
            if (i >= 0) {
                newNode = (UsageNode)this.myChildren.get(i);
            } else {
                int insertionIndex = -i - 1;
                this.myChildren.add(insertionIndex, newNode);
            }
        }
        edtInsertedUnderQueue.consume((Object)this);
        return newNode;
    }

    void incrementUsageCount() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        GroupNode groupNode = this;
        while (true) {
            ++groupNode.myRecursiveUsageCount;
            TreeNode parent = groupNode.getParent();
            if (!(parent instanceof GroupNode)) {
                return;
            }
            groupNode = (GroupNode)parent;
        }
    }

    @Override
    public String tree2string(int indent, String lineSeparator) {
        StringBuffer result = new StringBuffer();
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        if (this.getGroup() != null) {
            result.append(this.getGroup());
        }
        result.append("[");
        result.append(lineSeparator);
        for (Node node : this.myChildren) {
            result.append(node.tree2string(indent + 4, lineSeparator));
            result.append(lineSeparator);
        }
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        result.append("]");
        result.append(lineSeparator);
        return result.toString();
    }

    @Override
    protected boolean isDataValid() {
        UsageGroup group = this.getGroup();
        return group == null || group.isValid();
    }

    @Override
    protected boolean isDataReadOnly() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode element = enumeration.nextElement();
            if (!(element instanceof Node) || !((Node)element).isReadOnly()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull GroupNode groupNode) {
        if (this.myRuleIndex == groupNode.myRuleIndex) {
            return this.getGroup().compareTo(groupNode.getGroup());
        }
        return Integer.compare(this.myRuleIndex, groupNode.myRuleIndex);
    }

    public synchronized UsageGroup getGroup() {
        return (UsageGroup)this.getUserObject();
    }

    int getRecursiveUsageCount() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myRecursiveUsageCount;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (this.getGroup() != null) {
            this.getGroup().navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.getGroup() != null && this.getGroup().canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.getGroup() != null && this.getGroup().canNavigateToSource();
    }

    @Override
    protected boolean isDataExcluded() {
        for (Node node : this.myChildren) {
            if (node.isExcluded()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    protected String getText(@NotNull UsageView view) {
        return this.getGroup().getText(view);
    }

    @NotNull
    public synchronized Collection<GroupNode> getSubGroups() {
        ArrayList<GroupNode> list = new ArrayList<GroupNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof GroupNode)) continue;
            list.add((GroupNode)n);
        }
        return list;
    }

    @NotNull
    public synchronized Collection<UsageNode> getUsageNodes() {
        ArrayList<UsageNode> list = new ArrayList<UsageNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof UsageNode)) continue;
            list.add((UsageNode)n);
        }
        return list;
    }

    @NotNull
    static Root createRoot() {
        return new Root();
    }

    static class Root
    extends GroupNode {
        Root() {
        }

        @Override
        @NonNls
        public String toString() {
            return "Root " + super.toString();
        }

        @Override
        @NotNull
        protected String getText(@NotNull UsageView view) {
            return "";
        }
    }

    private static class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private NodeComparator() {
        }

        private static ClassIndex getClassIndex(DefaultMutableTreeNode node) {
            if (node instanceof UsageNode) {
                return ClassIndex.USAGE;
            }
            if (node instanceof GroupNode) {
                return ClassIndex.GROUP;
            }
            if (node instanceof UsageTargetNode) {
                return ClassIndex.USAGE_TARGET;
            }
            return ClassIndex.UNKNOWN;
        }

        @Override
        public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
            Object u2;
            int c;
            ClassIndex classIdx2;
            ClassIndex classIdx1 = NodeComparator.getClassIndex(n1);
            if (classIdx1 != (classIdx2 = NodeComparator.getClassIndex(n2))) {
                return classIdx1.compareTo(classIdx2);
            }
            if (classIdx1 == ClassIndex.GROUP ? (c = ((GroupNode)n1).compareTo((GroupNode)n2)) != 0 : classIdx1 == ClassIndex.USAGE && (c = ((UsageNode)n1).compareTo((UsageNode)n2)) != 0) {
                return c;
            }
            Object u1 = n1.getUserObject();
            if (Comparing.equal((Object)u1, (Object)(u2 = n2.getUserObject()))) {
                return 0;
            }
            return System.identityHashCode(u1) - System.identityHashCode(u2);
        }

        static enum ClassIndex {
            UNKNOWN,
            USAGE_TARGET,
            GROUP,
            USAGE;

        }
    }
}

