/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.SystemProperties;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class ExporterToTextFile
implements com.intellij.ide.ExporterToTextFile {
    private final UsageViewImpl myUsageView;
    @NotNull
    private final UsageViewSettings myUsageViewSettings;

    public ExporterToTextFile(@NotNull UsageViewImpl usageView, @NotNull UsageViewSettings usageViewSettings) {
        this.myUsageView = usageView;
        this.myUsageViewSettings = usageViewSettings;
    }

    @Override
    @NotNull
    public String getReportText() {
        StringBuilder buf = new StringBuilder();
        this.appendNode(buf, this.myUsageView.getModelRoot(), SystemProperties.getLineSeparator(), "");
        return buf.toString();
    }

    private void appendNode(StringBuilder buf, DefaultMutableTreeNode node, String lineSeparator, String indent) {
        String childIndent;
        buf.append(indent);
        if (node.getParent() != null) {
            childIndent = indent + "    ";
            this.appendNodeText(buf, node, lineSeparator);
        } else {
            childIndent = indent;
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            this.appendNode(buf, child, lineSeparator, childIndent);
        }
    }

    private void appendNodeText(StringBuilder buf, DefaultMutableTreeNode node, String lineSeparator) {
        if (node instanceof Node && ((Node)node).isExcluded()) {
            buf.append("(").append(UsageViewBundle.message("usage.excluded", new Object[0])).append(") ");
        }
        if (node instanceof UsageNode) {
            this.appendUsageNodeText(buf, (UsageNode)node);
        } else if (node instanceof GroupNode) {
            UsageGroup group = ((GroupNode)node).getGroup();
            buf.append(group != null ? group.getText(this.myUsageView) : UsageViewBundle.message("usages.title", new Object[0]));
            buf.append(" ");
            int count = ((GroupNode)node).getRecursiveUsageCount();
            buf.append(" (").append(UsageViewBundle.message("usages.n", count)).append(")");
        } else if (node instanceof UsageTargetNode) {
            buf.append(((UsageTargetNode)node).getTarget().getPresentation().getPresentableText());
        } else {
            buf.append(node.toString());
        }
        buf.append(lineSeparator);
    }

    protected void appendUsageNodeText(StringBuilder buf, UsageNode node) {
        TextChunk[] chunks = node.getUsage().getPresentation().getText();
        int chunkCount = 0;
        for (TextChunk chunk : chunks) {
            if (chunkCount == 1) {
                buf.append(" ");
            }
            buf.append(chunk.getText());
            ++chunkCount;
        }
    }

    @Override
    @NotNull
    public String getDefaultFilePath() {
        return this.myUsageViewSettings.getExportFileName();
    }

    @Override
    public void exportedTo(@NotNull String filePath2) {
        this.myUsageViewSettings.setExportFileName(filePath2);
    }

    @Override
    public boolean canExport() {
        return !this.myUsageView.isSearchInProgress() && this.myUsageView.areTargetsValid();
    }
}

