/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.usageView.UsageViewBundle;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageViewPresentation {
    private static final Logger LOG = Logger.getInstance(UsageViewPresentation.class);
    private String myTabText;
    private String myScopeText = "";
    private String myUsagesString;
    private String mySearchString;
    private String myTargetsNodeText = UsageViewBundle.message("node.targets", new Object[0]);
    private String myNonCodeUsagesString = UsageViewBundle.message("node.non.code.usages", new Object[0]);
    private String myCodeUsagesString = UsageViewBundle.message("node.found.usages", new Object[0]);
    private String myUsagesInGeneratedCodeString = UsageViewBundle.message("node.usages.in.generated.code", new Object[0]);
    private boolean myShowReadOnlyStatusAsRed = false;
    private boolean myShowCancelButton = false;
    private boolean myOpenInNewTab = true;
    private boolean myCodeUsages = true;
    private boolean myUsageTypeFilteringAvailable;
    private IntFunction<String> myUsagesWordSupplier = count -> UsageViewBundle.message("usage.name", count);
    private String myTabName;
    private String myToolwindowTitle;
    private boolean myDetachedMode;
    private String myDynamicCodeUsagesString;
    private boolean myMergeDupLinesAvailable = true;
    private boolean myExcludeAvailable = true;
    private Pattern mySearchPattern;
    private Pattern myReplacePattern;
    private boolean myReplaceMode;

    public String getTabText() {
        return this.myTabText;
    }

    public void setTabText(String tabText) {
        this.myTabText = tabText;
    }

    @NotNull
    public String getScopeText() {
        return this.myScopeText;
    }

    public void setScopeText(@NotNull String scopeText) {
        this.myScopeText = scopeText;
    }

    public boolean isShowReadOnlyStatusAsRed() {
        return this.myShowReadOnlyStatusAsRed;
    }

    public void setShowReadOnlyStatusAsRed(boolean showReadOnlyStatusAsRed) {
        this.myShowReadOnlyStatusAsRed = showReadOnlyStatusAsRed;
    }

    @Deprecated
    public String getUsagesString() {
        return this.myUsagesString;
    }

    @Deprecated
    public void setUsagesString(String usagesString) {
        this.myUsagesString = usagesString;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getSearchString() {
        String searchString = this.mySearchString;
        if (searchString != null) {
            return searchString;
        }
        String usagesString = this.myUsagesString;
        if (usagesString != null) {
            return StringUtil.capitalize((String)this.myUsagesString);
        }
        LOG.error("search string must be set");
        return "";
    }

    public void setSearchString(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String searchString) {
        this.mySearchString = searchString;
    }

    @Nullable(value="null means the targets node must not be visible")
    public @Nullable(value="null means the targets node must not be visible") String getTargetsNodeText() {
        return this.myTargetsNodeText;
    }

    public void setTargetsNodeText(String targetsNodeText) {
        this.myTargetsNodeText = targetsNodeText;
    }

    public boolean isShowCancelButton() {
        return this.myShowCancelButton;
    }

    public void setShowCancelButton(boolean showCancelButton) {
        this.myShowCancelButton = showCancelButton;
    }

    @NotNull
    public String getNonCodeUsagesString() {
        return this.myNonCodeUsagesString;
    }

    public void setNonCodeUsagesString(@NotNull String nonCodeUsagesString) {
        this.myNonCodeUsagesString = nonCodeUsagesString;
    }

    @NotNull
    public String getCodeUsagesString() {
        return this.myCodeUsagesString;
    }

    public void setCodeUsagesString(@NotNull String codeUsagesString) {
        this.myCodeUsagesString = codeUsagesString;
    }

    public boolean isOpenInNewTab() {
        return this.myOpenInNewTab;
    }

    public void setOpenInNewTab(boolean openInNewTab) {
        this.myOpenInNewTab = openInNewTab;
    }

    public boolean isCodeUsages() {
        return this.myCodeUsages;
    }

    public void setCodeUsages(boolean codeUsages) {
        this.myCodeUsages = codeUsages;
    }

    @NotNull
    public String getUsagesWord() {
        return this.myUsagesWordSupplier.apply(1);
    }

    @Deprecated
    public void setUsagesWord(@NotNull String usagesWord) {
        this.myUsagesWordSupplier = count -> usagesWord;
    }

    public void setUsagesWord(@NotNull IntFunction<String> usagesWordSupplier) {
        this.myUsagesWordSupplier = usagesWordSupplier;
    }

    public String getTabName() {
        return this.myTabName;
    }

    public void setTabName(String tabName) {
        this.myTabName = tabName;
    }

    public String getToolwindowTitle() {
        return this.myToolwindowTitle;
    }

    public void setToolwindowTitle(String toolwindowTitle) {
        this.myToolwindowTitle = toolwindowTitle;
    }

    public boolean isDetachedMode() {
        return this.myDetachedMode;
    }

    public void setDetachedMode(boolean detachedMode) {
        this.myDetachedMode = detachedMode;
    }

    public void setDynamicUsagesString(String dynamicCodeUsagesString) {
        this.myDynamicCodeUsagesString = dynamicCodeUsagesString;
    }

    public String getDynamicCodeUsagesString() {
        return this.myDynamicCodeUsagesString;
    }

    @NotNull
    public String getUsagesInGeneratedCodeString() {
        return this.myUsagesInGeneratedCodeString;
    }

    public void setUsagesInGeneratedCodeString(@NotNull String usagesInGeneratedCodeString) {
        this.myUsagesInGeneratedCodeString = usagesInGeneratedCodeString;
    }

    public boolean isMergeDupLinesAvailable() {
        return this.myMergeDupLinesAvailable;
    }

    public void setMergeDupLinesAvailable(boolean mergeDupLinesAvailable) {
        this.myMergeDupLinesAvailable = mergeDupLinesAvailable;
    }

    public boolean isUsageTypeFilteringAvailable() {
        return this.myCodeUsages || this.myUsageTypeFilteringAvailable;
    }

    public void setUsageTypeFilteringAvailable(boolean usageTypeFilteringAvailable) {
        this.myUsageTypeFilteringAvailable = usageTypeFilteringAvailable;
    }

    public boolean isExcludeAvailable() {
        return this.myExcludeAvailable;
    }

    public void setExcludeAvailable(boolean excludeAvailable) {
        this.myExcludeAvailable = excludeAvailable;
    }

    public void setSearchPattern(Pattern searchPattern) {
        this.mySearchPattern = searchPattern;
    }

    public Pattern getSearchPattern() {
        return this.mySearchPattern;
    }

    public void setReplacePattern(Pattern replacePattern) {
        this.myReplacePattern = replacePattern;
    }

    public Pattern getReplacePattern() {
        return this.myReplacePattern;
    }

    public boolean isReplaceMode() {
        return this.myReplaceMode;
    }

    public void setReplaceMode(boolean replaceMode) {
        this.myReplaceMode = replaceMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageViewPresentation that = (UsageViewPresentation)o;
        return this.myCodeUsages == that.myCodeUsages && this.myDetachedMode == that.myDetachedMode && this.myMergeDupLinesAvailable == that.myMergeDupLinesAvailable && this.myOpenInNewTab == that.myOpenInNewTab && this.myShowCancelButton == that.myShowCancelButton && this.myShowReadOnlyStatusAsRed == that.myShowReadOnlyStatusAsRed && this.myUsageTypeFilteringAvailable == that.myUsageTypeFilteringAvailable && this.myExcludeAvailable == that.myExcludeAvailable && this.myReplaceMode == that.myReplaceMode && Objects.equals(this.myCodeUsagesString, that.myCodeUsagesString) && Objects.equals(this.myDynamicCodeUsagesString, that.myDynamicCodeUsagesString) && Objects.equals(this.myNonCodeUsagesString, that.myNonCodeUsagesString) && Objects.equals(this.myScopeText, that.myScopeText) && Objects.equals(this.myTabName, that.myTabName) && Objects.equals(this.myTabText, that.myTabText) && Objects.equals(this.myTargetsNodeText, that.myTargetsNodeText) && Objects.equals(this.myToolwindowTitle, that.myToolwindowTitle) && Objects.equals(this.myUsagesInGeneratedCodeString, that.myUsagesInGeneratedCodeString) && Objects.equals(this.myUsagesString, that.myUsagesString) && Objects.equals(this.mySearchString, that.mySearchString) && Objects.equals(this.myUsagesWordSupplier.apply(1), that.myUsagesWordSupplier.apply(1)) && Objects.equals(this.myUsagesWordSupplier.apply(2), that.myUsagesWordSupplier.apply(2)) && UsageViewPresentation.arePatternsEqual(this.mySearchPattern, that.mySearchPattern) && UsageViewPresentation.arePatternsEqual(this.myReplacePattern, that.myReplacePattern);
    }

    public static boolean arePatternsEqual(Pattern p1, Pattern p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return Objects.equals(p1.pattern(), p2.pattern()) && p1.flags() == p2.flags();
    }

    public static int getHashCode(Pattern pattern) {
        if (pattern == null) {
            return 0;
        }
        String s = pattern.pattern();
        return (s != null ? s.hashCode() : 0) * 31 + pattern.flags();
    }

    public int hashCode() {
        int result = Objects.hash(this.myTabText, this.myScopeText, this.myUsagesString, this.mySearchString, this.myTargetsNodeText, this.myNonCodeUsagesString, this.myCodeUsagesString, this.myUsagesInGeneratedCodeString, this.myShowReadOnlyStatusAsRed, this.myShowCancelButton, this.myOpenInNewTab, this.myCodeUsages, this.myUsageTypeFilteringAvailable, this.myExcludeAvailable, this.myUsagesWordSupplier.apply(1), this.myUsagesWordSupplier.apply(2), this.myTabName, this.myToolwindowTitle, this.myDetachedMode, this.myDynamicCodeUsagesString, this.myMergeDupLinesAvailable, this.myReplaceMode);
        result = 31 * result + UsageViewPresentation.getHashCode(this.mySearchPattern);
        result = 31 * result + UsageViewPresentation.getHashCode(this.myReplacePattern);
        return result;
    }

    public UsageViewPresentation copy() {
        UsageViewPresentation copyInstance = new UsageViewPresentation();
        copyInstance.myTabText = this.myTabText;
        copyInstance.myScopeText = this.myScopeText;
        copyInstance.myUsagesString = this.myUsagesString;
        copyInstance.mySearchString = this.mySearchString;
        copyInstance.myTargetsNodeText = this.myTargetsNodeText;
        copyInstance.myNonCodeUsagesString = this.myNonCodeUsagesString;
        copyInstance.myCodeUsagesString = this.myCodeUsagesString;
        copyInstance.myUsagesInGeneratedCodeString = this.myUsagesInGeneratedCodeString;
        copyInstance.myShowReadOnlyStatusAsRed = this.myShowReadOnlyStatusAsRed;
        copyInstance.myShowCancelButton = this.myShowCancelButton;
        copyInstance.myOpenInNewTab = this.myOpenInNewTab;
        copyInstance.myCodeUsages = this.myCodeUsages;
        copyInstance.myUsageTypeFilteringAvailable = this.myUsageTypeFilteringAvailable;
        copyInstance.myUsagesWordSupplier = this.myUsagesWordSupplier;
        copyInstance.myTabName = this.myTabName;
        copyInstance.myToolwindowTitle = this.myToolwindowTitle;
        copyInstance.myDetachedMode = this.myDetachedMode;
        copyInstance.myDynamicCodeUsagesString = this.myDynamicCodeUsagesString;
        copyInstance.myMergeDupLinesAvailable = this.myMergeDupLinesAvailable;
        copyInstance.myExcludeAvailable = this.myExcludeAvailable;
        copyInstance.mySearchPattern = this.mySearchPattern;
        copyInstance.myReplacePattern = this.myReplacePattern;
        copyInstance.myReplaceMode = this.myReplaceMode;
        return copyInstance;
    }
}

