/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class TreeCollector<T> {
    private final AtomicReference<List<T>> reference = new AtomicReference();
    private final BiPredicate<? super T, ? super T> predicate;

    private TreeCollector(@NotNull BiPredicate<? super T, ? super T> predicate) {
        this.predicate = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<T> get() {
        AtomicReference<List<T>> atomicReference = this.reference;
        synchronized (atomicReference) {
            List list = this.reference.getAndSet(null);
            return list != null ? list : Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(@NotNull T object) {
        AtomicReference<List<T>> atomicReference = this.reference;
        synchronized (atomicReference) {
            List<T> list = this.reference.get();
            if (list != null) {
                return TreeCollector.add(this.predicate, list, object);
            }
            this.reference.set((List<T>)new SmartList(object));
            return true;
        }
    }

    @NotNull
    private static <T> List<T> collect(@NotNull BiPredicate<? super T, ? super T> predicate, T ... objects) {
        return ArrayUtil.isEmpty((Object[])objects) ? new ArrayList() : TreeCollector.collect(predicate, Arrays.asList(objects));
    }

    @NotNull
    private static <T> List<T> collect(@NotNull BiPredicate<? super T, ? super T> predicate, @NotNull Collection<? extends T> objects) {
        ArrayList list = new ArrayList(objects.size());
        for (T object : objects) {
            if (object == null) continue;
            TreeCollector.add(predicate, list, object);
        }
        return list;
    }

    private static <T> boolean add(@NotNull BiPredicate<? super T, ? super T> predicate, @NotNull List<T> list, @NotNull T object) {
        for (T each2 : list) {
            if (!predicate.test(each2, object)) continue;
            return false;
        }
        list.removeIf(each -> predicate.test(object, each));
        list.add(object);
        return true;
    }

    public static final class TreePathRoots {
        private static final BiPredicate<TreePath, TreePath> PREDICATE = (parent, child) -> parent.isDescendant((TreePath)child);

        @NotNull
        public static TreeCollector<TreePath> create() {
            return new TreeCollector<TreePath>(PREDICATE);
        }

        @NotNull
        public static List<TreePath> collect(TreePath ... paths) {
            return TreeCollector.collect(TreePathRoots.PREDICATE, paths);
        }

        @NotNull
        public static List<TreePath> collect(@NotNull Collection<? extends TreePath> paths) {
            return TreeCollector.collect(TreePathRoots.PREDICATE, paths);
        }
    }

    public static final class TreePathLeafs {
        private static final BiPredicate<TreePath, TreePath> PREDICATE = (child, parent) -> parent.isDescendant((TreePath)child);

        @NotNull
        public static TreeCollector<TreePath> create() {
            return new TreeCollector<TreePath>(PREDICATE);
        }

        @NotNull
        public static List<TreePath> collect(TreePath ... paths) {
            return TreeCollector.collect(TreePathLeafs.PREDICATE, paths);
        }

        @NotNull
        public static List<TreePath> collect(@NotNull Collection<? extends TreePath> paths) {
            return TreeCollector.collect(TreePathLeafs.PREDICATE, paths);
        }
    }

    public static final class VirtualFileRoots {
        private static final BiPredicate<VirtualFile, VirtualFile> PREDICATE = (parent, child) -> VfsUtilCore.isAncestor(parent, child, false);

        @NotNull
        public static TreeCollector<VirtualFile> create() {
            return new TreeCollector<VirtualFile>(PREDICATE);
        }

        @NotNull
        public static List<VirtualFile> collect(VirtualFile ... files) {
            return TreeCollector.collect(VirtualFileRoots.PREDICATE, files);
        }

        @NotNull
        public static List<VirtualFile> collect(@NotNull Collection<? extends VirtualFile> files) {
            return TreeCollector.collect(VirtualFileRoots.PREDICATE, files);
        }
    }

    public static final class VirtualFileLeafs {
        private static final BiPredicate<VirtualFile, VirtualFile> PREDICATE = (child, parent) -> VfsUtilCore.isAncestor(parent, child, false);

        @NotNull
        public static TreeCollector<VirtualFile> create() {
            return new TreeCollector<VirtualFile>(PREDICATE);
        }

        @NotNull
        public static List<VirtualFile> collect(VirtualFile ... files) {
            return TreeCollector.collect(VirtualFileLeafs.PREDICATE, files);
        }

        @NotNull
        public static List<VirtualFile> collect(@NotNull Collection<? extends VirtualFile> files) {
            return TreeCollector.collect(VirtualFileLeafs.PREDICATE, files);
        }
    }
}

