/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.tabs.JBEditorTabsBase;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.ui.tabs.impl.DefaultEditorTabsPainter;
import com.intellij.ui.tabs.impl.JBEditorTabsPainter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.singleRow.CompressibleSingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.ScrollableSingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import java.awt.Color;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBEditorTabs
extends JBTabsImpl
implements JBEditorTabsBase {
    @Deprecated
    protected JBEditorTabsPainter myDefaultPainter = new DefaultEditorTabsPainter(this);
    private boolean myAlphabeticalModeChanged = false;

    public JBEditorTabs(@Nullable Project project, @Nullable IdeFocusManager focusManager, @NotNull Disposable parentDisposable) {
        super(project, focusManager, parentDisposable);
        this.setSupportsCompression(true);
    }

    @Override
    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        this.resetTabsCache();
        this.relayout(true, false);
        super.uiSettingsChanged(uiSettings);
    }

    @Deprecated
    public JBEditorTabs(@Nullable Project project, @NotNull ActionManager actionManager, @Nullable IdeFocusManager focusManager, @NotNull Disposable parent) {
        this(project, focusManager, parent);
    }

    @Override
    protected SingleRowLayout createSingleRowLayout() {
        if (!UISettings.getInstance().getHideTabsIfNeeded() && this.supportsCompression()) {
            return new CompressibleSingleRowLayout(this);
        }
        return new ScrollableSingleRowLayout(this);
    }

    @Override
    public boolean isEditorTabs() {
        return true;
    }

    @Override
    public boolean useSmallLabels() {
        return UISettings.getInstance().getUseSmallLabelsOnTabs();
    }

    @Override
    public boolean isAlphabeticalMode() {
        if (this.myAlphabeticalModeChanged) {
            return super.isAlphabeticalMode();
        }
        return UISettings.getInstance().getSortTabsAlphabetically();
    }

    @Override
    public JBTabsPresentation setAlphabeticalMode(boolean alphabeticalMode) {
        this.myAlphabeticalModeChanged = true;
        return super.setAlphabeticalMode(alphabeticalMode);
    }

    @Override
    public void setEmptySpaceColorCallback(@NotNull Supplier<? extends Color> callback) {
    }

    @Deprecated
    protected Color getEmptySpaceColor() {
        return this.myTabPainter.getBackgroundColor();
    }
}

