/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.AllOccurrencesMatcher;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.UIUtil;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpeedSearch
extends SpeedSearchSupply
implements KeyListener {
    public static final String PUNCTUATION_MARKS = "*_-+\"'/.#$>: ,;?!@%^&";
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    private final boolean myMatchAllOccurrences;
    private String myString = "";
    private boolean myEnabled;
    private Matcher myMatcher;

    public SpeedSearch() {
        this(false);
    }

    public SpeedSearch(boolean matchAllOccurrences) {
        this.myMatchAllOccurrences = matchAllOccurrences;
    }

    public void type(String letter) {
        this.updatePattern(this.myString + letter);
    }

    public void backspace() {
        if (this.myString.length() > 0) {
            this.updatePattern(this.myString.substring(0, this.myString.length() - 1));
        }
    }

    public boolean shouldBeShowing(String string) {
        return string == null || this.myString.length() == 0 || this.myMatcher != null && this.myMatcher.matches(string);
    }

    public void processKeyEvent(KeyEvent e) {
        if (e.isConsumed() || !this.myEnabled) {
            return;
        }
        String old = this.myString;
        if (e.getID() == 401) {
            if (KeymapUtil.isEventForAction(e, "EditorDeleteToWordStart")) {
                if (this.isHoldingFilter()) {
                    while (!this.myString.isEmpty() && !Character.isWhitespace(this.myString.charAt(this.myString.length() - 1))) {
                        this.backspace();
                    }
                    e.consume();
                }
            } else if (e.getKeyCode() == 8) {
                this.backspace();
                e.consume();
            } else if (e.getKeyCode() == 27 && this.isHoldingFilter()) {
                this.updatePattern("");
                e.consume();
            }
        } else if (e.getID() == 400) {
            if (!UIUtil.isReallyTypedEvent((KeyEvent)e)) {
                return;
            }
            char ch = e.getKeyChar();
            if (Character.isLetterOrDigit(ch) || !this.startedWithWhitespace(ch) && PUNCTUATION_MARKS.indexOf(ch) != -1) {
                this.type(Character.toString(ch));
                e.consume();
            }
        }
        if (!old.equalsIgnoreCase(this.myString)) {
            this.update();
        }
    }

    private boolean startedWithWhitespace(char ch) {
        return !this.isHoldingFilter() && Character.isWhitespace(ch);
    }

    public void update() {
    }

    public void noHits() {
    }

    public boolean isHoldingFilter() {
        return this.myEnabled && this.myString.length() > 0;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void reset() {
        if (this.isHoldingFilter()) {
            this.updatePattern("");
        }
        if (this.myEnabled) {
            this.update();
        }
    }

    public String getFilter() {
        return this.myString;
    }

    public void updatePattern(String string) {
        String prevString = this.myString;
        this.myString = string;
        try {
            String pattern = "*" + string;
            NameUtil.MatchingCaseSensitivity caseSensitivity = NameUtil.MatchingCaseSensitivity.NONE;
            String separators = "";
            this.myMatcher = this.myMatchAllOccurrences ? AllOccurrencesMatcher.create((String)pattern, (NameUtil.MatchingCaseSensitivity)caseSensitivity, (String)separators) : new FixingLayoutMatcher(pattern, caseSensitivity, separators);
        }
        catch (Exception e) {
            this.myMatcher = null;
        }
        this.fireStateChanged(prevString);
    }

    @Nullable
    public Matcher getMatcher() {
        return this.myMatcher;
    }

    @Override
    @Nullable
    public Iterable<TextRange> matchingFragments(@NotNull String text) {
        if (this.myMatcher instanceof MinusculeMatcher) {
            return ((MinusculeMatcher)this.myMatcher).matchingFragments(text);
        }
        return null;
    }

    @Override
    public void refreshSelection() {
    }

    @Override
    public boolean isPopupActive() {
        return this.isHoldingFilter();
    }

    @Override
    @Nullable
    public String getEnteredPrefix() {
        return this.myString;
    }

    @Override
    public void addChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    @Override
    public void removeChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    private void fireStateChanged(String prevString) {
        this.myChangeSupport.firePropertyChange("enteredPrefix", prevString, this.getEnteredPrefix());
    }

    @Override
    public void findAndSelectElement(@NotNull String searchQuery) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.processKeyEvent(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.processKeyEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.processKeyEvent(e);
    }
}

