/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandlerAdapter;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.jetbrains.annotations.NotNull;

class JBCefLoadHtmlResourceHandler
extends CefResourceHandlerAdapter {
    private static final Logger LOG = Logger.getInstance((String)JBCefLoadHtmlResourceHandler.class.getName());
    @NotNull
    private final InputStream myInputStream;

    JBCefLoadHtmlResourceHandler(@NotNull String html) {
        this.myInputStream = new ByteArrayInputStream(html.getBytes(Charset.defaultCharset()));
    }

    public boolean processRequest(@NotNull CefRequest request, @NotNull CefCallback callback) {
        callback.Continue();
        return true;
    }

    public void getResponseHeaders(@NotNull CefResponse response, IntRef response_length, StringRef redirectUrl) {
        response.setMimeType("text/html");
        response.setStatus(200);
    }

    public boolean readResponse(byte @NotNull [] data_out, int bytes_to_read, IntRef bytes_read, CefCallback callback) {
        try {
            int availableSize = this.myInputStream.available();
            if (availableSize > 0) {
                int bytesToRead = Math.min(bytes_to_read, availableSize);
                bytesToRead = this.myInputStream.read(data_out, 0, bytesToRead);
                bytes_read.set(bytesToRead);
                return true;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        bytes_read.set(0);
        try {
            this.myInputStream.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }
}

