/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.panels;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class StatelessCardLayout
implements LayoutManager2 {
    public static final StatelessCardLayout INSTANCE = new StatelessCardLayout();

    @NotNull
    public static JPanel wrap(Component component) {
        JPanel panel2 = new JPanel(INSTANCE);
        if (component != null) {
            panel2.add(component);
        }
        panel2.setOpaque(false);
        return panel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void show(Component visible) {
        Container container;
        if (visible != null && !visible.isVisible() && (container = visible.getParent()) != null) {
            Object object = container.getTreeLock();
            synchronized (object) {
                for (Component component : container.getComponents()) {
                    component.setVisible(component == visible);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component getComponent(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            for (Component component : container.getComponents()) {
                if (!component.isVisible()) continue;
                return component;
            }
        }
        return null;
    }

    private static Dimension getSize(Container container, Dimension size) {
        Insets insets = container.getInsets();
        if (insets != null) {
            int height;
            int width = size.width + insets.left + insets.right;
            if (size.width < width) {
                size.width = width;
            }
            if (size.height < (height = size.height + insets.top + insets.bottom)) {
                size.height = height;
            }
        }
        return size;
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
        this.addLayoutComponent(component, name);
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints != null) {
            throw new IllegalArgumentException("unsupported constraints: " + constraints);
        }
        Container container = component.getParent();
        component.setVisible(container != null && 0 < container.getComponentCount());
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        Component component = StatelessCardLayout.getComponent(container);
        return component != null ? component.getAlignmentX() : 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        Component component = StatelessCardLayout.getComponent(container);
        return component != null ? component.getAlignmentY() : 0.5f;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Component component = StatelessCardLayout.getComponent(container);
        return StatelessCardLayout.getSize(container, component != null ? component.getPreferredSize() : new Dimension());
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Component component = StatelessCardLayout.getComponent(container);
        return StatelessCardLayout.getSize(container, component != null ? component.getMinimumSize() : new Dimension());
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        Component component = StatelessCardLayout.getComponent(container);
        return StatelessCardLayout.getSize(container, component != null ? component.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            boolean logged = false;
            boolean updated = false;
            for (Component component : container.getComponents()) {
                if (!component.isVisible()) continue;
                if (!updated) {
                    updated = true;
                    Dimension min = component.getMinimumSize();
                    Dimension max = component.getMaximumSize();
                    if (max.height < min.height) {
                        max.height = min.height;
                    }
                    Rectangle bounds = new Rectangle(container.getWidth(), container.getHeight());
                    JBInsets.removeFrom((Rectangle)bounds, (Insets)container.getInsets());
                    if (max.width < min.width) {
                        max.width = min.width;
                    }
                    if (bounds.width > max.width) {
                        bounds.x += (int)(0.5f + (float)(bounds.width - max.width) * component.getAlignmentX());
                        bounds.width = max.width;
                    } else if (bounds.width < min.width) {
                        bounds.x += (int)(0.5f + (float)(bounds.width - min.width) * component.getAlignmentX());
                        bounds.width = min.width;
                    }
                    if (max.height < min.height) {
                        max.height = min.height;
                    }
                    if (bounds.height > max.height) {
                        bounds.y += (int)(0.5f + (float)(bounds.height - max.height) * component.getAlignmentY());
                        bounds.height = max.height;
                    } else if (bounds.height < min.height) {
                        bounds.y += (int)(0.5f + (float)(bounds.height - min.height) * component.getAlignmentY());
                        bounds.height = min.height;
                    }
                    component.setBounds(bounds);
                    continue;
                }
                component.setVisible(false);
                if (logged) continue;
                logged = true;
                Logger.getInstance(StatelessCardLayout.class).warn("too many visible components");
            }
        }
    }
}

