/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields.valueEditors;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.ui.components.fields.valueEditors.TextFieldValueEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommaSeparatedIntegersValueEditor
extends TextFieldValueEditor<List<Integer>> {
    private final int myMinValue;
    private final int myMaxValue;

    public CommaSeparatedIntegersValueEditor(@NotNull JTextField field, @Nullable String valueName, int minValue, int maxValue) {
        super(field, valueName, Collections.emptyList());
        this.myMinValue = minValue;
        this.myMaxValue = maxValue;
    }

    @Override
    @NotNull
    public List<Integer> parseValue(@Nullable String text) throws InvalidDataException {
        if (text == null || text.isEmpty()) {
            return Collections.emptyList();
        }
        String[] chunks = text.split("\\s*,\\s*");
        ArrayList<Integer> values = new ArrayList<Integer>(chunks.length);
        for (String chunk : chunks) {
            try {
                int value = Integer.parseInt(chunk);
                if (value < this.myMinValue || value > this.myMaxValue) {
                    throw new InvalidDataException("Value " + value + " is out of range " + this.myMinValue + ".." + this.myMaxValue);
                }
                values.add(value);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidDataException("Value '" + chunk + "' is not an integer number");
            }
        }
        Collections.sort(values);
        return values;
    }

    @Override
    public String valueToString(@NotNull List<Integer> valueList) {
        return CommaSeparatedIntegersValueEditor.intListToString(valueList);
    }

    @Override
    public boolean isValid(@NotNull List<Integer> value) {
        return true;
    }

    public static String intListToString(@NotNull List<Integer> valueList) {
        StringBuilder sb = new StringBuilder();
        for (Integer value : valueList) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(value);
        }
        return sb.toString();
    }
}

