/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.valueEditors.IntegerValueEditor;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerField
extends JBTextField {
    private final IntegerValueEditor myValueEditor;

    public IntegerField() {
        this(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerField(@Nullable String valueName, int minValue, int maxValue) {
        this.myValueEditor = new IntegerValueEditor((JTextField)this, valueName, minValue);
        this.myValueEditor.setMinValue(minValue);
        this.myValueEditor.setMaxValue(maxValue);
    }

    public int getMinValue() {
        return this.myValueEditor.getMinValue();
    }

    public int getMaxValue() {
        return this.myValueEditor.getMaxValue();
    }

    public void setMinValue(int minValue) {
        this.myValueEditor.setMinValue(minValue);
    }

    public void setMaxValue(int maxValue) {
        this.myValueEditor.setMaxValue(maxValue);
    }

    public boolean isCanBeEmpty() {
        return this.myValueEditor.isCanBeEmpty();
    }

    public void setCanBeEmpty(boolean canBeEmpty) {
        this.myValueEditor.setCanBeEmpty(canBeEmpty);
    }

    @NotNull
    public Integer getValue() {
        return (Integer)this.myValueEditor.getValue();
    }

    public void setValue(@NotNull Integer newValue) {
        this.myValueEditor.setValue(newValue);
    }

    public void setValueName(@Nullable String valueName) {
        this.myValueEditor.setValueName(valueName);
    }

    @Nullable
    public String getValueName() {
        return this.myValueEditor.getValueName();
    }

    public void validateContent() throws ConfigurationException {
        this.myValueEditor.validateContent();
    }

    public void setDefaultValueText(@NotNull String text) {
        this.getEmptyText().setText(text);
    }

    public void setDefaultValue(@NotNull Integer defaultValue) {
        this.myValueEditor.setDefaultValue(defaultValue);
    }

    @NotNull
    public Integer getDefaultValue() {
        return (Integer)this.myValueEditor.getDefaultValue();
    }

    public void resetToDefault() {
        this.myValueEditor.setValue(this.myValueEditor.getDefaultValue());
    }

    public IntegerValueEditor getValueEditor() {
        return this.myValueEditor;
    }
}

