/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendableTextField
extends JBTextField
implements ExtendableTextComponent {
    private List<ExtendableTextComponent.Extension> extensions = Collections.emptyList();

    public ExtendableTextField() {
        this(null);
    }

    public ExtendableTextField(int columns) {
        this(null, columns);
    }

    public ExtendableTextField(String text) {
        this(text, 20);
    }

    public ExtendableTextField(String text, int columns) {
        super(text, columns);
    }

    @Override
    public List<ExtendableTextComponent.Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    public void setExtensions(ExtendableTextComponent.Extension ... extensions) {
        this.setExtensions(Arrays.asList(extensions));
    }

    @Override
    public void setExtensions(Collection<? extends ExtendableTextComponent.Extension> extensions) {
        this.setExtensions((List<? extends ExtendableTextComponent.Extension>)new ArrayList<ExtendableTextComponent.Extension>(extensions));
    }

    private void setExtensions(List<? extends ExtendableTextComponent.Extension> extensions) {
        this.putClientProperty("JTextField.variant", null);
        this.extensions = Collections.unmodifiableList(extensions);
        this.putClientProperty("JTextField.variant", "extendable");
    }

    @Override
    public void addExtension(@NotNull ExtendableTextComponent.Extension extension) {
        if (!this.getExtensions().contains(extension)) {
            ArrayList<ExtendableTextComponent.Extension> extensions = new ArrayList<ExtendableTextComponent.Extension>(this.getExtensions());
            extensions.add(extension);
            this.setExtensions((List<? extends ExtendableTextComponent.Extension>)extensions);
        }
    }

    @Override
    public void removeExtension(@NotNull ExtendableTextComponent.Extension extension) {
        ArrayList<ExtendableTextComponent.Extension> extensions = new ArrayList<ExtendableTextComponent.Extension>(this.getExtensions());
        if (extensions.remove(extension)) {
            this.setExtensions((List<? extends ExtendableTextComponent.Extension>)extensions);
        }
    }

    @Override
    @Deprecated
    public void setUI(TextUI ui) {
        TextUI suggested = ui;
        try {
            if (ui == null || !Class.forName("com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI").isAssignableFrom(ui.getClass())) {
                ui = (TextUI)Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI").getDeclaredMethod("createUI", JComponent.class).invoke(null, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setUI(ui);
        if (ui != suggested) {
            try {
                this.setBorder((Border)Class.forName("com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder").newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ApiStatus.Experimental
    public ExtendableTextField addBrowseExtension(final @NotNull Runnable action, @Nullable Disposable parentDisposable) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 64);
        String tooltip = UIBundle.message("component.with.browse.button.browse.button.tooltip.text", new Object[0]) + " (" + KeymapUtil.getKeystrokeText(keyStroke) + ")";
        ExtendableTextComponent.Extension browseExtension = ExtendableTextComponent.Extension.create(AllIcons.General.OpenDisk, AllIcons.General.OpenDiskHover, tooltip, action);
        new DumbAwareAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                action.run();
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(keyStroke), this, parentDisposable);
        this.addExtension(browseExtension);
        return this;
    }
}

