/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Expandable;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class ExpandableSupport<Source extends JComponent>
implements Expandable {
    private final Source source;
    private final Function<? super String, String> onShow;
    private final Function<? super String, String> onHide;
    private JBPopup popup;
    private String title;
    private String comment;

    public ExpandableSupport(@NotNull Source source, Function<? super String, String> onShow, Function<? super String, String> onHide) {
        this.source = source;
        this.onShow = onShow != null ? onShow : Functions.identity();
        this.onHide = onHide != null ? onHide : Functions.identity();
        ((JComponent)source).putClientProperty(Expandable.class, this);
        ((JComponent)source).addAncestorListener(EventHandler.create(AncestorListener.class, this, "collapse"));
        ((Component)source).addComponentListener(EventHandler.create(ComponentListener.class, this, "collapse"));
    }

    @NotNull
    protected abstract Content prepare(@NotNull Source var1, @NotNull Function<? super String, String> var2);

    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    public final String getComment() {
        return this.comment;
    }

    public final void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public final boolean isExpanded() {
        return this.popup != null;
    }

    @Override
    public final void collapse() {
        if (this.popup != null) {
            this.popup.cancel();
        }
    }

    @Override
    public final void expand() {
        if (this.popup != null || !((Component)this.source).isEnabled()) {
            return;
        }
        Content content = this.prepare(this.source, this.onShow);
        JComponent component = content.getContentComponent();
        Dimension size = component.getPreferredSize();
        if (size.width - 50 < ((JComponent)this.source).getWidth()) {
            size.width = ((JComponent)this.source).getWidth();
        }
        if (size.height < 2 * ((JComponent)this.source).getHeight()) {
            size.height = 2 * ((JComponent)this.source).getHeight();
        }
        Point location = new Point(0, 0);
        SwingUtilities.convertPointToScreen(location, this.source);
        Rectangle screen = ScreenUtil.getScreenRectangle(this.source);
        int bottom = screen.y - location.y + screen.height;
        if (bottom < size.height) {
            int top = location.y - screen.y + ((JComponent)this.source).getHeight();
            if (top < bottom) {
                size.height = bottom;
            } else {
                if (size.height > top) {
                    size.height = top;
                }
                location.y -= size.height - ((JComponent)this.source).getHeight();
            }
        }
        component.setPreferredSize(size);
        this.popup = JBPopupFactory.getInstance().createComponentPopupBuilder(component, content.getFocusableComponent()).setMayBeParent(true).setFocusable(true).setRequestFocus(true).setTitle(this.title).setAdText(this.comment).setLocateByContent(true).setCancelOnWindowDeactivation(false).setKeyboardActions(Collections.singletonList(Pair.create(event -> {
            this.collapse();
            Window window = ComponentUtil.getWindow(this.source);
            if (window != null) {
                window.dispatchEvent(new KeyEvent((Component)this.source, 401, System.currentTimeMillis(), 2, 10, '\r'));
            }
        }, (Object)KeyStroke.getKeyStroke(10, 2)))).setCancelCallback((Computable<Boolean>)((Computable)() -> {
            try {
                content.cancel(this.onHide);
                this.popup = null;
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        })).createPopup();
        this.popup.show(new RelativePoint(location));
    }

    @NotNull
    public ExtendableTextComponent.Extension createCollapseExtension() {
        return ExtendableTextComponent.Extension.create(AllIcons.General.CollapseComponent, AllIcons.General.CollapseComponentHover, KeymapUtil.createTooltipText("Collapse", "CollapseExpandableComponent"), this::collapse);
    }

    @NotNull
    public ExtendableTextComponent.Extension createExpandExtension() {
        return ExtendableTextComponent.Extension.create(AllIcons.General.ExpandComponent, AllIcons.General.ExpandComponentHover, KeymapUtil.createTooltipText("Expand", "ExpandExpandableComponent"), this::expand);
    }

    @NotNull
    public static JLabel createLabel(final @NotNull ExtendableTextComponent.Extension extension) {
        return new JLabel(extension.getIcon(false)){
            {
                super(x0);
                this.setToolTipText(extension.getTooltip());
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent event) {
                        this.setIcon(extension.getIcon(true));
                    }

                    @Override
                    public void mouseExited(MouseEvent event) {
                        this.setIcon(extension.getIcon(false));
                    }

                    @Override
                    public void mouseClicked(MouseEvent event) {
                        Runnable action = extension.getActionOnClick();
                        if (action != null) {
                            action.run();
                        }
                    }
                });
            }
        };
    }

    protected static interface Content {
        @NotNull
        public JComponent getContentComponent();

        public JComponent getFocusableComponent();

        public void cancel(@NotNull Function<? super String, String> var1);
    }
}

