/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.Clipboard;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class TreeCopyProvider
implements CopyProvider {
    private static final Logger LOG = Logger.getInstance(TreeCopyProvider.class);
    private final JTree myTree;

    public TreeCopyProvider(JTree tree) {
        this.myTree = tree;
    }

    @Override
    public void performCopy(@NotNull DataContext dataContext) {
        try {
            Clipboard clipboard = this.myTree.getToolkit().getSystemClipboard();
            this.myTree.getTransferHandler().exportToClipboard(this.myTree, clipboard, 1);
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
        }
    }

    @Override
    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return this.myTree.getSelectionPath() != null;
    }

    @Override
    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }
}

