/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionProvider;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorNotificationPanel
extends JPanel
implements IntentionActionProvider,
Weighted {
    protected final JLabel myLabel = new JLabel();
    protected final JLabel myGearLabel = new JLabel();
    protected final JPanel myLinksPanel = new NonOpaquePanel(new HorizontalLayout(JBUIScale.scale((int)16)));
    protected Color myBackgroundColor;
    protected ColorKey myBackgroundColorKey;
    @Nullable
    private Key<?> myProviderKey;
    private Project myProject;

    public EditorNotificationPanel(@Nullable Color backgroundColor) {
        this();
        this.myBackgroundColor = backgroundColor;
    }

    public EditorNotificationPanel(@Nullable ColorKey backgroundColorKey) {
        this();
        this.myBackgroundColorKey = backgroundColorKey;
    }

    public EditorNotificationPanel() {
        super(new BorderLayout());
        NonOpaquePanel panel2 = new NonOpaquePanel(new BorderLayout());
        panel2.add("Center", this.myLabel);
        panel2.add("East", this.myLinksPanel);
        panel2.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)5));
        panel2.setMinimumSize(new Dimension(0, 0));
        this.add("Center", panel2);
        this.add("East", this.myGearLabel);
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public void setProviderKey(@Nullable Key<?> key) {
        this.myProviderKey = key;
    }

    public static Color getToolbarBackground() {
        return UIUtil.getPanelBackground();
    }

    public void setText(@NlsContexts.LinkLabel String text) {
        this.myLabel.setText(text);
    }

    public EditorNotificationPanel text(@NotNull @NlsContexts.Label String text) {
        this.myLabel.setText(text);
        return this;
    }

    @NotNull
    public String getText() {
        return this.myLabel.getText();
    }

    public EditorNotificationPanel icon(@NotNull Icon icon) {
        this.myLabel.setIcon(icon);
        return this;
    }

    @Override
    public Color getBackground() {
        Color color;
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (this.myBackgroundColor != null) {
            return this.myBackgroundColor;
        }
        if (this.myBackgroundColorKey != null && (color = globalScheme.getColor(this.myBackgroundColorKey)) != null) {
            return color;
        }
        color = globalScheme.getColor(EditorColors.NOTIFICATION_BACKGROUND);
        return color != null ? color : UIUtil.getToolTipBackground();
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@NlsContexts.LinkLabel String text, @NonNls String actionId) {
        return this.createActionLabel(text, actionId, true);
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@NlsContexts.LinkLabel String text, @NonNls String actionId, boolean showInIntentionMenu) {
        return this.createActionLabel(text, () -> this.executeAction(actionId), showInIntentionMenu);
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@NlsContexts.LinkLabel String text, @NotNull Runnable action) {
        return this.createActionLabel(text, action, true);
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@NlsContexts.LinkLabel String text, @NotNull Runnable action, boolean showInIntentionMenu) {
        return this.createActionLabelImpl(text, this.withLogNotifications(action), showInIntentionMenu);
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@NlsContexts.LinkLabel String text, ActionHandler handler, boolean showInIntentionMenu) {
        return this.createActionLabelImpl(text, this.withNotifications(handler), showInIntentionMenu);
    }

    @NotNull
    private HyperlinkLabel createActionLabelImpl(@NlsContexts.LinkLabel String text, ActionHandler handler, boolean showInIntentionMenu) {
        ActionHyperlinkLabel label = new ActionHyperlinkLabel(this, text, this.getBackground(), showInIntentionMenu, handler);
        this.myLinksPanel.add(label);
        return label;
    }

    protected void executeAction(@NonNls String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        AnActionEvent event = AnActionEvent.createFromAnAction(action, null, this.getActionPlace(), DataManager.getInstance().getDataContext(this));
        action.beforeActionPerformedUpdate(event);
        action.update(event);
        if (event.getPresentation().isEnabled() && event.getPresentation().isVisible()) {
            ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
            actionManager.fireBeforeActionPerformed(action, event.getDataContext(), event);
            action.actionPerformed(event);
            actionManager.fireAfterActionPerformed(action, event.getDataContext(), event);
        }
    }

    @NotNull
    protected String getActionPlace() {
        return "unknown";
    }

    @Override
    @Nullable
    public IntentionActionWithOptions getIntentionAction() {
        MyIntentionAction action = new MyIntentionAction();
        return action.myOptions.isEmpty() ? null : action;
    }

    @Override
    public double getWeight() {
        return 0.0;
    }

    @Nullable
    protected String getIntentionActionText() {
        return null;
    }

    @NotNull
    protected PriorityAction.Priority getIntentionActionPriority() {
        return PriorityAction.Priority.NORMAL;
    }

    @NotNull
    @Nls
    protected String getIntentionActionFamilyName() {
        return IdeBundle.message("intention.family.editor.notification", new Object[0]);
    }

    private void logNotificationActionInvocation(@NotNull Object handlerClass) {
        if (this.myProject != null) {
            EditorNotifications.getInstance(this.myProject).logNotificationActionInvocation(this.myProviderKey, handlerClass.getClass());
        }
    }

    @NotNull
    private ActionHandler withLogNotifications(final @NotNull Runnable action) {
        return new ActionHandler(){

            @Override
            public void handlePanelActionClick(@NotNull EditorNotificationPanel panel2, @NotNull HyperlinkEvent e) {
                EditorNotificationPanel.this.logNotificationActionInvocation(action);
                action.run();
            }

            @Override
            public void handleQuickFixClick(@NotNull Editor editor, @NotNull PsiFile file) {
                EditorNotificationPanel.this.logNotificationActionInvocation(action);
                action.run();
            }
        };
    }

    @NotNull
    private ActionHandler withNotifications(final @NotNull ActionHandler handler) {
        return new ActionHandler(){

            @Override
            public void handlePanelActionClick(@NotNull EditorNotificationPanel panel2, @NotNull HyperlinkEvent e) {
                EditorNotificationPanel.this.logNotificationActionInvocation(handler);
                handler.handlePanelActionClick(panel2, e);
            }

            @Override
            public void handleQuickFixClick(@NotNull Editor editor, @NotNull PsiFile file) {
                EditorNotificationPanel.this.logNotificationActionInvocation(handler);
                handler.handleQuickFixClick(editor, file);
            }
        };
    }

    private static class MySettingsOption
    implements IntentionAction,
    Iconable,
    LowPriorityAction {
        private final JLabel myLabel;

        private MySettingsOption(JLabel label) {
            this.myLabel = label;
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            return EditorBundle.message("editor.notification.settings.option.name", new Object[0]);
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            return IdeBundle.message("intention.family.editor.notification.settings", new Object[0]);
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            return true;
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 501, System.currentTimeMillis(), 0, 0, 0, 1, false));
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 502, System.currentTimeMillis(), 0, 0, 0, 1, false));
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 500, System.currentTimeMillis(), 0, 0, 0, 1, false));
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return this.myLabel.getIcon();
        }
    }

    private static class MyLinkOption
    implements IntentionAction {
        private final HyperlinkLabel myLabel;

        private MyLinkOption(HyperlinkLabel label) {
            this.myLabel = label;
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            return this.myLabel.getText();
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            return IdeBundle.message("intention.family.editor.notification.option", new Object[0]);
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            return true;
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (this.myLabel instanceof ActionHyperlinkLabel) {
                ((ActionHyperlinkLabel)this.myLabel).handleIntentionActionClick(editor, file);
            } else {
                this.myLabel.doClick();
            }
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }
    }

    private class MyIntentionAction
    implements IntentionActionWithOptions,
    Iconable,
    PriorityAction {
        private final List<IntentionAction> myOptions = new ArrayList<IntentionAction>();

        private MyIntentionAction() {
            for (Component component : EditorNotificationPanel.this.myLinksPanel.getComponents()) {
                if (!(component instanceof HyperlinkLabel) || component instanceof ActionHyperlinkLabel && !((ActionHyperlinkLabel)component).myShowInIntentionMenu) continue;
                this.myOptions.add(new MyLinkOption((HyperlinkLabel)component));
            }
            if (EditorNotificationPanel.this.myGearLabel.getIcon() != null) {
                this.myOptions.add(new MySettingsOption(EditorNotificationPanel.this.myGearLabel));
            }
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            this.myOptions.get(0).invoke(project, editor, file);
        }

        @Override
        public boolean startInWriteAction() {
            return this.myOptions.get(0).startInWriteAction();
        }

        @Override
        @NotNull
        public List<IntentionAction> getOptions() {
            return this.myOptions.isEmpty() ? Collections.emptyList() : this.myOptions.subList(1, this.myOptions.size());
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String textOverride = EditorNotificationPanel.this.getIntentionActionText();
            if (textOverride != null) {
                return textOverride;
            }
            if (!this.myOptions.isEmpty()) {
                return this.myOptions.get(0).getText();
            }
            String text = EditorNotificationPanel.this.myLabel.getText();
            return StringUtil.isEmpty((String)text) ? EditorBundle.message("editor.notification.default.action.name", new Object[0]) : StringUtil.shortenTextWithEllipsis((String)text, (int)50, (int)0);
        }

        @Override
        @NotNull
        public PriorityAction.Priority getPriority() {
            return EditorNotificationPanel.this.getIntentionActionPriority();
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            return EditorNotificationPanel.this.getIntentionActionFamilyName();
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            return true;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return AllIcons.Actions.IntentionBulb;
        }
    }

    private static class ActionHyperlinkLabel
    extends HyperlinkLabel {
        private final boolean myShowInIntentionMenu;
        private final ActionHandler myHandler;

        private ActionHyperlinkLabel(final @NotNull EditorNotificationPanel notificationPanel, @NlsContexts.LinkLabel String text, Color background, boolean showInIntentionMenu, @NotNull ActionHandler handler) {
            super(text, background);
            this.myShowInIntentionMenu = showInIntentionMenu;
            this.myHandler = handler;
            this.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    if (e == null) {
                        return;
                    }
                    myHandler.handlePanelActionClick(notificationPanel, e);
                }
            });
        }

        void handleIntentionActionClick(Editor editor, PsiFile file) {
            if (editor == null || file == null) {
                return;
            }
            this.myHandler.handleQuickFixClick(editor, file);
        }
    }

    public static interface ActionHandler {
        public void handlePanelActionClick(@NotNull EditorNotificationPanel var1, @NotNull HyperlinkEvent var2);

        public void handleQuickFixClick(@NotNull Editor var1, @NotNull PsiFile var2);
    }
}

