/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ClickListener;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.OpenSourceUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class AutoScrollToSourceHandler {
    private final Alarm myAutoScrollAlarm = new Alarm();

    public void install(final JTree tree) {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (clickCount > 1) {
                    return false;
                }
                TreePath location = tree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                if (location != null) {
                    AutoScrollToSourceHandler.this.onMouseClicked(tree);
                }
                return false;
            }
        }.installOn((Component)tree);
        tree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(tree);
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(tree);
            }
        });
    }

    public void install(final JTable table) {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (clickCount >= 2) {
                    return false;
                }
                Component location = table.getComponentAt(e.getPoint());
                if (location != null) {
                    AutoScrollToSourceHandler.this.onMouseClicked(table);
                    return AutoScrollToSourceHandler.this.isAutoScrollMode();
                }
                return false;
            }
        }.installOn((Component)table);
        table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(table);
            }
        });
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(table);
            }
        });
    }

    public void install(final JList jList) {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (clickCount >= 2) {
                    return false;
                }
                Object source = e.getSource();
                int index = jList.locationToIndex(SwingUtilities.convertPoint(source instanceof Component ? (Component)source : null, e.getPoint(), jList));
                if (index >= 0 && index < jList.getModel().getSize()) {
                    AutoScrollToSourceHandler.this.onMouseClicked(jList);
                    return true;
                }
                return false;
            }
        }.installOn((Component)jList);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AutoScrollToSourceHandler.this.onSelectionChanged(jList);
            }
        });
    }

    public void cancelAllRequests() {
        this.myAutoScrollAlarm.cancelAllRequests();
    }

    public void onMouseClicked(Component component) {
        this.cancelAllRequests();
        if (this.isAutoScrollMode()) {
            ApplicationManager.getApplication().invokeLater(() -> this.scrollToSource(component));
        }
    }

    private void onSelectionChanged(Component component) {
        if (component != null && component.isShowing() && this.isAutoScrollMode()) {
            this.myAutoScrollAlarm.cancelAllRequests();
            this.myAutoScrollAlarm.addRequest(() -> {
                if (component.isShowing() && (!this.needToCheckFocus() || component.hasFocus())) {
                    this.scrollToSource(component);
                }
            }, 500);
        }
    }

    protected String getActionName() {
        return UIBundle.message("autoscroll.to.source.action.name", new Object[0]);
    }

    protected String getActionDescription() {
        return UIBundle.message("autoscroll.to.source.action.description", new Object[0]);
    }

    protected boolean needToCheckFocus() {
        return true;
    }

    protected abstract boolean isAutoScrollMode();

    protected abstract void setAutoScrollMode(boolean var1);

    protected boolean isAutoScrollEnabledFor(@NotNull VirtualFile file) {
        FileType type = file.getFileType();
        if (type == FileTypes.UNKNOWN || type instanceof INativeFileType) {
            return false;
        }
        return file.getLength() <= (long)PersistentFSConstants.getMaxIntellisenseFileSize();
    }

    protected void scrollToSource(Component tree) {
        DataContext dataContext = DataManager.getInstance().getDataContext(tree);
        this.getReady(dataContext).doWhenDone(() -> ApplicationManager.getApplication().invokeLater(() -> {
            DataContext context = DataManager.getInstance().getDataContext(tree);
            VirtualFile vFile = CommonDataKeys.VIRTUAL_FILE.getData(context);
            Navigatable[] navigatables = CommonDataKeys.NAVIGATABLE_ARRAY.getData(context);
            if (navigatables != null && navigatables.length == 1 && (vFile == null || this.isAutoScrollEnabledFor(vFile))) {
                OpenSourceUtil.navigateToSource(false, true, navigatables[0]);
            }
        }));
    }

    @NotNull
    public ToggleAction createToggleAction() {
        return new AutoscrollToSourceAction(this.getActionName(), this.getActionDescription());
    }

    private ActionCallback getReady(DataContext context) {
        ToolWindow toolWindow = PlatformDataKeys.TOOL_WINDOW.getData(context);
        return toolWindow != null ? toolWindow.getReady(this) : ActionCallback.DONE;
    }

    private class AutoscrollToSourceAction
    extends ToggleAction
    implements DumbAware {
        AutoscrollToSourceAction(String actionName, String actionDescription) {
            super(actionName, actionDescription, AllIcons.General.AutoscrollToSource);
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent event) {
            return AutoScrollToSourceHandler.this.isAutoScrollMode();
        }

        @Override
        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            AutoScrollToSourceHandler.this.setAutoScrollMode(flag);
        }
    }
}

