/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositorySubtype;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.config.TaskRepositoryEditor;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TaskRepositoryType<T extends TaskRepository>
implements TaskRepositorySubtype,
Comparable<TaskRepositoryType> {
    public static final ExtensionPointName<TaskRepositoryType<?>> EP_NAME = new ExtensionPointName("com.intellij.tasks.repositoryType");

    @NotNull
    public static List<TaskRepositoryType<?>> getRepositoryTypes() {
        return EP_NAME.getExtensionList();
    }

    @NotNull
    public static List<Class<?>> getRepositoryClasses() {
        return ContainerUtil.map(TaskRepositoryType.getRepositoryTypes(), TaskRepositoryType::getRepositoryClass);
    }

    public static <T> void addEPListChangeListener(@NotNull Disposable disposable, @NotNull Runnable listener2) {
        EP_NAME.addChangeListener(listener2, disposable);
    }

    @Override
    @NotNull
    public abstract String getName();

    @Override
    @NotNull
    public abstract Icon getIcon();

    @Nullable
    public String getAdvertiser() {
        return null;
    }

    @NotNull
    public abstract TaskRepositoryEditor createEditor(T var1, Project var2, Consumer<T> var3);

    public List<TaskRepositorySubtype> getAvailableSubtypes() {
        return Collections.singletonList(this);
    }

    @NotNull
    public TaskRepository createRepository(TaskRepositorySubtype subtype) {
        return subtype.createRepository();
    }

    @Override
    @NotNull
    public abstract TaskRepository createRepository();

    public abstract Class<T> getRepositoryClass();

    @Deprecated
    public EnumSet<TaskState> getPossibleTaskStates() {
        return EnumSet.noneOf(TaskState.class);
    }

    public int getSortOrder() {
        return 0;
    }

    @Override
    public int compareTo(@NotNull TaskRepositoryType other) {
        return other.getSortOrder() - this.getSortOrder();
    }
}

