/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.tasks.TaskState;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomTaskState {
    private String myId = "";
    private String myPresentableName = "";
    private boolean myPredefined;

    public CustomTaskState() {
    }

    public CustomTaskState(@NotNull String id, @NotNull String name) {
        this.myId = id;
        this.myPresentableName = name;
    }

    @Attribute(value="id")
    @NotNull
    public String getId() {
        return this.myId;
    }

    public void setId(@NotNull String id) {
        this.myId = id;
    }

    @Attribute(value="name")
    @NotNull
    public String getPresentableName() {
        return this.myPresentableName;
    }

    public void setPresentableName(@NotNull String name) {
        this.myPresentableName = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomTaskState)) {
            return false;
        }
        CustomTaskState state = (CustomTaskState)o;
        return this.myId.equals(state.myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    @NotNull
    public static CustomTaskState fromPredefined(@NotNull TaskState state) {
        CustomTaskState result = new CustomTaskState(state.name(), state.getPresentableName());
        result.setPredefined(true);
        return result;
    }

    @Nullable
    public TaskState asPredefined() {
        if (this.isPredefined()) {
            try {
                return TaskState.valueOf(this.getId());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Attribute(value="predefined")
    public boolean isPredefined() {
        return this.myPredefined;
    }

    public void setPredefined(boolean predefined) {
        this.myPredefined = predefined;
    }

    public String toString() {
        return "CustomTaskState(id='" + this.myId + '\'' + ", name='" + this.myPresentableName + '\'' + ", predefined=" + this.myPredefined + ')';
    }
}

