/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task;

import com.intellij.execution.Executor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class ProjectTaskRunner {
    public static final ExtensionPointName<ProjectTaskRunner> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectTaskRunner");
    private static final Key<Boolean> RECURSION_GUARD_KEY = KeyWithDefaultValue.create((String)"recursion guard key", (Object)false);

    public Promise<Result> run(@NotNull Project project, @NotNull ProjectTaskContext context, ProjectTask ... tasks) {
        AsyncPromise promise = new AsyncPromise();
        this.run(project, context, (ProjectTaskNotification)new ProjectTaskNotificationAdapter(promise), tasks);
        return promise;
    }

    public abstract boolean canRun(@NotNull ProjectTask var1);

    public boolean canRun(@NotNull Project project, @NotNull ProjectTask projectTask) {
        return this.canRun(projectTask);
    }

    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ExecuteRunConfigurationTask task, @Nullable Executor executor) {
        return null;
    }

    @ApiStatus.Experimental
    public boolean isFileGeneratedEventsSupported() {
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks) {
        if (!((Boolean)RECURSION_GUARD_KEY.get((UserDataHolder)context)).booleanValue()) {
            RECURSION_GUARD_KEY.set((UserDataHolder)context, (Object)true);
            this.run(project, context, callback, tasks.toArray(ProjectTaskManager.EMPTY_TASKS_ARRAY));
            RECURSION_GUARD_KEY.set((UserDataHolder)context, (Object)false);
        } else {
            ProjectTaskRunner.assertUnsupportedOperation(callback);
            ProjectTaskRunner.notifyIfNeeded(this.run(project, context, tasks.toArray(new ProjectTask[0])), callback);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback, ProjectTask ... tasks) {
        if (!((Boolean)RECURSION_GUARD_KEY.get((UserDataHolder)context)).booleanValue()) {
            RECURSION_GUARD_KEY.set((UserDataHolder)context, (Object)true);
            this.run(project, context, callback, Arrays.asList(tasks));
            RECURSION_GUARD_KEY.set((UserDataHolder)context, (Object)false);
        } else {
            ProjectTaskRunner.assertUnsupportedOperation(callback);
            ProjectTaskRunner.notifyIfNeeded(this.run(project, context, tasks), callback);
        }
    }

    private static void notifyIfNeeded(@NotNull Promise<Result> promise, @Nullable ProjectTaskNotification callback) {
        if (callback != null) {
            promise.onSuccess(result -> callback.finished(new ProjectTaskResult(result.isAborted(), result.hasErrors() ? 1 : 0, 0))).onError(throwable -> callback.finished(new ProjectTaskResult(true, 0, 0)));
        }
    }

    private static void assertUnsupportedOperation(@Nullable ProjectTaskNotification callback) {
        if (callback instanceof ProjectTaskNotificationAdapter) {
            throw new UnsupportedOperationException("Please, provide implementation non-deprecated ProjectTaskRunner.run(Project, ProjectTaskContext, ProjectTask...) method");
        }
    }

    private static class ProjectTaskNotificationAdapter
    implements ProjectTaskNotification {
        private final AsyncPromise<Result> myPromise;

        private ProjectTaskNotificationAdapter(@NotNull AsyncPromise<Result> promise) {
            this.myPromise = promise;
        }

        @Override
        public void finished(final @NotNull ProjectTaskResult taskResult) {
            this.myPromise.setResult((Object)new Result(){

                @Override
                public boolean isAborted() {
                    return taskResult.isAborted();
                }

                @Override
                public boolean hasErrors() {
                    return taskResult.getErrors() > 0;
                }
            });
        }
    }

    public static interface Result {
        public boolean isAborted();

        public boolean hasErrors();
    }
}

