/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public abstract class IndexPatternSearch
extends ExtensibleQueryFactory<IndexPatternOccurrence, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<IndexPatternOccurrence, SearchParameters>> EP_NAME = ExtensionPointName.create((String)"com.intellij.indexPatternSearch");
    private static IndexPatternSearch ourInstance;

    protected IndexPatternSearch() {
        super(EP_NAME);
    }

    private static IndexPatternSearch getInstance() {
        IndexPatternSearch result = ourInstance;
        if (result == null) {
            ourInstance = result = (IndexPatternSearch)ApplicationManager.getApplication().getService(IndexPatternSearch.class);
        }
        return result;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
        SearchParameters parameters = new SearchParameters(file, pattern);
        return IndexPatternSearch.getInstance().createQuery(parameters);
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPattern pattern, int startOffset, int endOffset) {
        SearchParameters parameters = new SearchParameters(file, pattern, new TextRange(startOffset, endOffset));
        return IndexPatternSearch.getInstance().createQuery(parameters);
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
        SearchParameters parameters = new SearchParameters(file, patternProvider);
        return IndexPatternSearch.getInstance().createQuery(parameters);
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, boolean multiLineOccurrences) {
        SearchParameters parameters = new SearchParameters(file, patternProvider, multiLineOccurrences);
        return IndexPatternSearch.getInstance().createQuery(parameters);
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, int startOffset, int endOffset) {
        SearchParameters parameters = new SearchParameters(file, patternProvider, new TextRange(startOffset, endOffset));
        return IndexPatternSearch.getInstance().createQuery(parameters);
    }

    public static int getOccurrencesCount(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
        return IndexPatternSearch.getInstance().getOccurrencesCountImpl(file, patternProvider);
    }

    public static int getOccurrencesCount(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
        return IndexPatternSearch.getInstance().getOccurrencesCountImpl(file, pattern);
    }

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPatternProvider var2);

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPattern var2);

    public static final class SearchParameters {
        private final PsiFile myFile;
        private final IndexPattern myPattern;
        private final IndexPatternProvider myPatternProvider;
        private final TextRange myRange;
        private final boolean myMultiLine;

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
            this(file, pattern, null);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPattern pattern, TextRange range) {
            this.myFile = file;
            this.myRange = range;
            this.myPatternProvider = null;
            this.myPattern = pattern;
            this.myMultiLine = false;
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
            this(file, patternProvider, null, false);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, boolean multiLine) {
            this(file, patternProvider, null, multiLine);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, TextRange range) {
            this(file, patternProvider, range, false);
        }

        private SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, TextRange range, boolean multiLine) {
            this.myFile = file;
            this.myPatternProvider = patternProvider;
            this.myRange = range;
            this.myPattern = null;
            this.myMultiLine = multiLine;
        }

        @NotNull
        public PsiFile getFile() {
            return this.myFile;
        }

        public IndexPattern getPattern() {
            return this.myPattern;
        }

        public IndexPatternProvider getPatternProvider() {
            return this.myPatternProvider;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        public boolean isMultiLine() {
            return this.myMultiLine;
        }
    }
}

