/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamedScopesHolder
implements PersistentStateComponent<Element> {
    private NamedScope[] myScopes = NamedScope.EMPTY_ARRAY;
    @NonNls
    private static final String SCOPE_TAG = "scope";
    @NonNls
    private static final String NAME_ATT = "name";
    @NonNls
    private static final String PATTERN_ATT = "pattern";
    protected final Project myProject;
    private VirtualFile myProjectBaseDir;
    private final List<ScopeListener> myScopeListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public NamedScopesHolder(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public abstract String getDisplayName();

    public abstract Icon getIcon();

    public VirtualFile getProjectBaseDir() {
        if (this.myProjectBaseDir == null) {
            this.myProjectBaseDir = this.myProject.getBaseDir();
        }
        return this.myProjectBaseDir;
    }

    @Deprecated
    public void addScopeListener(@NotNull ScopeListener scopeListener) {
        this.myScopeListeners.add(scopeListener);
    }

    public void addScopeListener(@NotNull ScopeListener scopeListener, @NotNull Disposable parentDisposable) {
        this.myScopeListeners.add(scopeListener);
        Disposer.register((Disposable)parentDisposable, () -> this.myScopeListeners.remove(scopeListener));
    }

    public void fireScopeListeners() {
        for (ScopeListener listener2 : this.myScopeListeners) {
            listener2.scopesChanged();
        }
    }

    public NamedScope @NotNull [] getScopes() {
        List<NamedScope> list = this.getPredefinedScopes();
        ArrayList<NamedScope> scopes = new ArrayList<NamedScope>(list.size() + this.myScopes.length);
        scopes.addAll(list);
        Collections.addAll(scopes, this.myScopes);
        return scopes.toArray(NamedScope.EMPTY_ARRAY);
    }

    public NamedScope @NotNull [] getEditableScopes() {
        return this.myScopes;
    }

    public void removeAllSets() {
        this.myScopes = NamedScope.EMPTY_ARRAY;
        this.fireScopeListeners();
    }

    public void setScopes(NamedScope @NotNull [] scopes) {
        if (ArrayUtil.contains(null, (Object[])scopes)) {
            throw new IllegalArgumentException("Must not pass null scopes, got: " + Arrays.toString(scopes));
        }
        this.myScopes = (NamedScope[])scopes.clone();
        this.fireScopeListeners();
    }

    public void addScope(@NotNull NamedScope scope) {
        this.myScopes = (NamedScope[])ArrayUtil.append((Object[])this.myScopes, (Object)scope);
        this.fireScopeListeners();
    }

    @Nullable
    public static NamedScope getScope(@NotNull Project project, String scopeName) {
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders(project)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    public static NamedScopesHolder @NotNull [] getAllNamedScopeHolders(@NotNull Project project) {
        return new NamedScopesHolder[]{NamedScopeManager.getInstance(project), DependencyValidationManager.getInstance(project)};
    }

    @Contract(value="_,_,!null -> !null")
    public static NamedScopesHolder getHolder(Project project, String scopeName, NamedScopesHolder defaultHolder) {
        NamedScopesHolder[] holders;
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders(project)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return holder;
        }
        return defaultHolder;
    }

    @NotNull
    private static Element writeScope(@NotNull NamedScope scope) {
        Element setElement = new Element(SCOPE_TAG);
        setElement.setAttribute(NAME_ATT, scope.getName());
        PackageSet packageSet = scope.getValue();
        setElement.setAttribute(PATTERN_ATT, packageSet != null ? packageSet.getText() : "");
        return setElement;
    }

    @NotNull
    private NamedScope readScope(@NotNull Element setElement) {
        PackageSet set;
        String name = setElement.getAttributeValue(NAME_ATT);
        String attributeValue = setElement.getAttributeValue(PATTERN_ATT);
        try {
            set = PackageSetFactory.getInstance().compile(attributeValue);
        }
        catch (ParsingException e) {
            set = new InvalidPackageSet(attributeValue);
        }
        return this.createScope(name, set);
    }

    @Override
    public void loadState(@NotNull Element state) {
        List sets = state.getChildren(SCOPE_TAG);
        this.myScopes = new NamedScope[sets.size()];
        for (int i = 0; i < sets.size(); ++i) {
            Element set = (Element)sets.get(i);
            this.myScopes[i] = this.readScope(set);
        }
        this.fireScopeListeners();
    }

    @Override
    @NotNull
    public Element getState() {
        Element element = new Element("state");
        for (NamedScope myScope : this.myScopes) {
            element.addContent(NamedScopesHolder.writeScope(myScope));
        }
        return element;
    }

    @Nullable
    public NamedScope getScope(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (NamedScope scope : this.myScopes) {
            if (!name.equals(scope.getName())) continue;
            return scope;
        }
        return this.getPredefinedScope(name);
    }

    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        return Collections.emptyList();
    }

    @Nullable
    public NamedScope getPredefinedScope(@NotNull String name) {
        return null;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final NamedScope createScope(@NotNull String name, @Nullable PackageSet value) {
        return new NamedScope(name, this.getIcon(), value);
    }

    @FunctionalInterface
    public static interface ScopeListener {
        public void scopesChanged();
    }
}

