/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.FilteredPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectFilesScope
extends NamedScope {
    public static final ProjectFilesScope INSTANCE = new ProjectFilesScope();

    public ProjectFilesScope() {
        super(ProjectFilesScope.getNameText(), AllIcons.Nodes.Folder, new FilteredPackageSet(ProjectFilesScope.getNameText()){

            @Override
            public boolean contains(@NotNull VirtualFile file, @NotNull Project project) {
                ProjectFileIndex fileIndex = ProjectFilesScope.getFileIndex(project);
                return fileIndex != null && !fileIndex.isExcluded(file) && fileIndex.getContentRootForFile(file) != null;
            }
        });
    }

    @Nullable
    static ProjectFileIndex getFileIndex(@NotNull Project project) {
        return !project.isInitialized() ? null : ProjectRootManager.getInstance(project).getFileIndex();
    }

    public static String getNameText() {
        return AnalysisBundle.message("predefined.scope.project.files.name", new Object[0]);
    }
}

