/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import org.jetbrains.annotations.NotNull;

public final class ProjectScope {
    private static final NotNullLazyKey<GlobalSearchScope, Project> ALL_SCOPE_KEY = NotNullLazyKey.create((String)"ALL_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildAllScope());
    private static final NotNullLazyKey<GlobalSearchScope, Project> PROJECT_SCOPE_KEY = NotNullLazyKey.create((String)"PROJECT_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildProjectScope());
    private static final NotNullLazyKey<GlobalSearchScope, Project> LIBRARIES_SCOPE_KEY = NotNullLazyKey.create((String)"LIBRARIES_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildLibrariesScope());
    private static final NotNullLazyKey<GlobalSearchScope, Project> CONTENT_SCOPE_KEY = NotNullLazyKey.create((String)"CONTENT_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildContentScope());
    private static final NotNullLazyKey<GlobalSearchScope, Project> EVERYTHING_SCOPE_KEY = NotNullLazyKey.create((String)"EVERYTHING_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildEverythingScope());

    private ProjectScope() {
    }

    @NotNull
    public static GlobalSearchScope getAllScope(@NotNull Project project) {
        return (GlobalSearchScope)ALL_SCOPE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public static GlobalSearchScope getProjectScope(@NotNull Project project) {
        return (GlobalSearchScope)PROJECT_SCOPE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public static GlobalSearchScope getLibrariesScope(@NotNull Project project) {
        return (GlobalSearchScope)LIBRARIES_SCOPE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public static GlobalSearchScope getContentScope(@NotNull Project project) {
        return (GlobalSearchScope)CONTENT_SCOPE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public static GlobalSearchScope getEverythingScope(@NotNull Project project) {
        return (GlobalSearchScope)EVERYTHING_SCOPE_KEY.getValue((UserDataHolder)project);
    }
}

