/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NonClasspathDirectoriesScope
extends GlobalSearchScope {
    private final Set<VirtualFile> myRoots;

    public NonClasspathDirectoriesScope(@NotNull Collection<VirtualFile> roots) {
        this.myRoots = new HashSet<VirtualFile>(roots);
    }

    @NotNull
    public static GlobalSearchScope compose(@NotNull List<VirtualFile> roots) {
        if (roots.isEmpty()) {
            return EMPTY_SCOPE;
        }
        return new NonClasspathDirectoriesScope(roots);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        return VfsUtilCore.isUnder(file, this.myRoots);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return false;
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonClasspathDirectoriesScope)) {
            return false;
        }
        NonClasspathDirectoriesScope that = (NonClasspathDirectoriesScope)o;
        return this.myRoots.equals(that.myRoots);
    }

    @Override
    public int calcHashCode() {
        return this.myRoots.hashCode();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if (this.myRoots.size() == 1) {
            VirtualFile root = this.myRoots.iterator().next();
            return CoreBundle.message("scope.display.name.directory.0", root.getName());
        }
        return CoreBundle.message("scope.display.name.directories.0", StringUtil.join(this.myRoots, file -> "'" + file.getName() + "'", (String)", "));
    }
}

