/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.presentation;

import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSelectSettingPresentation
extends CodeStyleSettingPresentation {
    protected int @NotNull [] myValues;
    protected String @NotNull [] myValueUiNames;
    protected int myLowerBound;
    protected int myUpperBound;

    public CodeStyleSelectSettingPresentation(@NotNull String fieldName, @NotNull String uiName, int @NotNull [] values, String @NotNull [] valueUiNames) {
        super(fieldName, uiName);
        assert (values.length == valueUiNames.length);
        assert (values.length > 0);
        this.myValues = values;
        this.myValueUiNames = valueUiNames;
        this.myLowerBound = values[0];
        this.myUpperBound = values[0];
        for (int value : values) {
            this.myLowerBound = Math.min(value, this.myLowerBound);
            this.myUpperBound = Math.max(value, this.myUpperBound);
        }
    }

    @Override
    @NotNull
    public String getValueUiName(@NotNull Object value) {
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            for (int i = 0; i < this.myValues.length; ++i) {
                if (this.myValues[i] != intValue) continue;
                return this.myValueUiNames[i];
            }
        }
        return super.getValueUiName(value);
    }

    public int getLowerBound() {
        return this.myLowerBound;
    }

    public int getUpperBound() {
        return this.myUpperBound;
    }

    public int @NotNull [] getValues() {
        return this.myValues;
    }

    public String @NotNull [] getOptions() {
        return this.myValueUiNames;
    }
}

