/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.model;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ArrangementCompositeMatchCondition
implements ArrangementMatchCondition {
    @NotNull
    private final Set<ArrangementMatchCondition> myOperands = new HashSet<ArrangementMatchCondition>();

    public ArrangementCompositeMatchCondition() {
    }

    public ArrangementCompositeMatchCondition(@NotNull Collection<? extends ArrangementMatchCondition> conditions) {
        this.myOperands.addAll(conditions);
    }

    @NotNull
    public Set<ArrangementMatchCondition> getOperands() {
        return this.myOperands;
    }

    @NotNull
    public ArrangementCompositeMatchCondition addOperand(@NotNull ArrangementMatchCondition condition) {
        this.myOperands.add(condition);
        return this;
    }

    public void removeOperand(@NotNull ArrangementMatchCondition condition) {
        this.myOperands.remove(condition);
    }

    @Override
    public void invite(@NotNull ArrangementMatchConditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    @NotNull
    public ArrangementCompositeMatchCondition clone() {
        ArrangementCompositeMatchCondition result = new ArrangementCompositeMatchCondition();
        for (ArrangementMatchCondition operand : this.myOperands) {
            result.addOperand(operand.clone());
        }
        return result;
    }

    public int hashCode() {
        return this.myOperands.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementCompositeMatchCondition setting = (ArrangementCompositeMatchCondition)o;
        return this.myOperands.equals(setting.myOperands);
    }

    public String toString() {
        return String.format("(%s)", StringUtil.join(this.myOperands, (String)" and "));
    }
}

