/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionDetector {
    private final Document myDocument;
    private final ArrangementSettings mySettings;
    private final Consumer<? super ArrangementSectionEntryTemplate> mySectionEntryProducer;
    private final Stack<ArrangementSectionRule> myOpenedSections = new Stack();

    public ArrangementSectionDetector(@Nullable Document document, @NotNull ArrangementSettings settings, @NotNull Consumer<? super ArrangementSectionEntryTemplate> producer) {
        this.myDocument = document;
        this.mySettings = settings;
        this.mySectionEntryProducer = producer;
    }

    public boolean processComment(@NotNull PsiComment comment) {
        ArrangementSectionRule lastSection;
        TextRange range = comment.getTextRange();
        TextRange expandedRange = this.myDocument == null ? range : ArrangementUtil.expandToLineIfPossible(range, this.myDocument);
        TextRange sectionTextRange = new TextRange(expandedRange.getStartOffset(), expandedRange.getEndOffset());
        String commentText = comment.getText().trim();
        ArrangementSectionRule openSectionRule = ArrangementSectionDetector.isSectionStartComment(this.mySettings, commentText);
        if (openSectionRule != null) {
            this.mySectionEntryProducer.consume((Object)new ArrangementSectionEntryTemplate(comment, StdArrangementTokens.Section.START_SECTION, sectionTextRange, commentText));
            this.myOpenedSections.push((Object)openSectionRule);
            return true;
        }
        if (!this.myOpenedSections.isEmpty() && (lastSection = (ArrangementSectionRule)this.myOpenedSections.peek()).getEndComment() != null && StringUtil.equals((CharSequence)commentText, (CharSequence)lastSection.getEndComment())) {
            this.mySectionEntryProducer.consume((Object)new ArrangementSectionEntryTemplate(comment, StdArrangementTokens.Section.END_SECTION, sectionTextRange, commentText));
            this.myOpenedSections.pop();
            return true;
        }
        return false;
    }

    @Nullable
    public static ArrangementSectionRule isSectionStartComment(@NotNull ArrangementSettings settings, @NotNull String comment) {
        for (ArrangementSectionRule rule : settings.getSections()) {
            if (rule.getStartComment() == null || !StringUtil.equals((CharSequence)comment, (CharSequence)rule.getStartComment())) continue;
            return rule;
        }
        return null;
    }

    public static class ArrangementSectionEntryTemplate {
        private final PsiElement myElement;
        private final ArrangementSettingsToken myToken;
        private final TextRange myTextRange;
        private final String myText;

        public ArrangementSectionEntryTemplate(@NotNull PsiElement element, @NotNull ArrangementSettingsToken token, @NotNull TextRange range, @NotNull String text) {
            this.myElement = element;
            this.myToken = token;
            this.myTextRange = range;
            this.myText = text;
        }

        @NotNull
        public PsiElement getElement() {
            return this.myElement;
        }

        @NotNull
        public ArrangementSettingsToken getToken() {
            return this.myToken;
        }

        @NotNull
        public TextRange getTextRange() {
            return this.myTextRange;
        }

        @NotNull
        public String getText() {
            return this.myText;
        }
    }
}

