/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.formatting.fileSet.FileSetDescriptor;
import com.intellij.formatting.fileSet.FileSetDescriptorFactory;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ExcludedFiles {
    private final List<FileSetDescriptor> myDescriptors = new ArrayList<FileSetDescriptor>();
    private final State myState = new State();

    public void serializeInto(@NotNull Element element) {
        if (this.myDescriptors.size() > 0) {
            XmlSerializer.serializeInto((Object)this.myState, (Element)element);
        }
    }

    public void deserializeFrom(@NotNull Element element) {
        XmlSerializer.deserializeInto((Object)this.myState, (Element)element);
    }

    public void addDescriptor(@NotNull FileSetDescriptor descriptor) {
        this.myDescriptors.add(descriptor);
    }

    public List<FileSetDescriptor> getDescriptors() {
        return this.myDescriptors;
    }

    public void setDescriptors(@NotNull List<? extends FileSetDescriptor> descriptors) {
        this.myDescriptors.clear();
        this.myDescriptors.addAll(descriptors);
    }

    public boolean contains(@NotNull PsiFile file) {
        if (file.isPhysical()) {
            for (FileSetDescriptor descriptor : this.myDescriptors) {
                if (!descriptor.matches(file)) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.myDescriptors.clear();
    }

    public boolean equals(@NotNull Object o) {
        return o instanceof ExcludedFiles && this.myDescriptors.equals(((ExcludedFiles)o).myDescriptors);
    }

    public class State {
        @OptionTag(value="DO_NOT_FORMAT")
        public List<FileSetDescriptor.State> getDescriptors() {
            return ContainerUtil.map((Collection)ExcludedFiles.this.myDescriptors, descriptor -> descriptor.getState());
        }

        public void setDescriptors(@NotNull List<FileSetDescriptor.State> states) {
            ExcludedFiles.this.myDescriptors.clear();
            for (FileSetDescriptor.State state : states) {
                FileSetDescriptor descriptor = FileSetDescriptorFactory.createDescriptor(state);
                if (descriptor == null) continue;
                ExcludedFiles.this.myDescriptors.add(descriptor);
            }
        }
    }
}

