/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ResolveState {
    private static final ResolveState ourInitialState = new ResolveState();

    @NotNull
    public static ResolveState initial() {
        return ourInitialState;
    }

    @NotNull
    public <T> ResolveState put(@NotNull Key<T> key, T value) {
        return new OneElementResolveState(key, value);
    }

    @NotNull
    public ResolveState putAll(@NotNull ResolveState state) {
        return state;
    }

    public <T> T get(@NotNull Key<T> key) {
        if (key instanceof KeyWithDefaultValue) {
            return (T)((KeyWithDefaultValue)key).getDefaultValue();
        }
        return null;
    }

    private static class ManyElementResolveState
    extends ResolveState {
        private final Map<Object, Object> myValues = new THashMap();

        ManyElementResolveState(@NotNull ResolveState state1, @NotNull ResolveState state2) {
            this.putAllNoCopy(state1);
            this.putAllNoCopy(state2);
        }

        ManyElementResolveState(@NotNull ResolveState state, @NotNull Key key, Object value) {
            this.putAllNoCopy(state);
            this.myValues.put(key, value);
        }

        private void putAllNoCopy(@NotNull ResolveState other) {
            if (other instanceof OneElementResolveState) {
                OneElementResolveState oneState = (OneElementResolveState)other;
                this.myValues.put(oneState.myKey, oneState.myValue);
            } else if (other instanceof TwoElementResolveState) {
                TwoElementResolveState twoState = (TwoElementResolveState)other;
                this.myValues.put(twoState.myKey1, twoState.myValue1);
                this.myValues.put(twoState.myKey2, twoState.myValue2);
            } else if (other instanceof ManyElementResolveState) {
                ManyElementResolveState manyState = (ManyElementResolveState)other;
                this.myValues.putAll(manyState.myValues);
            }
        }

        @Override
        @NotNull
        public <T> ResolveState put(@NotNull Key<T> key, T value) {
            return new ManyElementResolveState(this, key, value);
        }

        @Override
        @NotNull
        public ResolveState putAll(@NotNull ResolveState state) {
            if (state == ourInitialState) {
                return this;
            }
            return new ManyElementResolveState(this, state);
        }

        @Override
        public <T> T get(@NotNull Key<T> key) {
            Object value = this.myValues.get(key);
            if (value == null && key instanceof KeyWithDefaultValue) {
                return (T)((KeyWithDefaultValue)key).getDefaultValue();
            }
            return (T)value;
        }
    }

    private static class TwoElementResolveState
    extends ResolveState {
        @NotNull
        private final Key myKey1;
        private final Object myValue1;
        @NotNull
        private final Key myKey2;
        private final Object myValue2;

        TwoElementResolveState(@NotNull Key key1, Object value1, @NotNull Key key2, Object value2) {
            this.myKey1 = key1;
            this.myValue1 = value1;
            this.myKey2 = key2;
            this.myValue2 = value2;
        }

        @Override
        @NotNull
        public <T> ResolveState put(@NotNull Key<T> key, T value) {
            if (this.myKey1.equals(key)) {
                return new TwoElementResolveState(key, value, this.myKey2, this.myValue2);
            }
            if (this.myKey2.equals(key)) {
                return new TwoElementResolveState(this.myKey1, this.myValue1, key, value);
            }
            return new ManyElementResolveState(this, key, value);
        }

        @Override
        @NotNull
        public ResolveState putAll(@NotNull ResolveState state) {
            boolean has2;
            if (state == ourInitialState) {
                return this;
            }
            if (state instanceof OneElementResolveState) {
                OneElementResolveState oneState = (OneElementResolveState)state;
                return this.put(oneState.myKey, oneState.myValue);
            }
            boolean has1 = state.get(this.myKey1) != null;
            boolean bl = has2 = state.get(this.myKey2) != null;
            if (has1 && has2) {
                return state;
            }
            if (has1) {
                return state.put(this.myKey2, this.myValue2);
            }
            if (has2) {
                return state.put(this.myKey1, this.myValue1);
            }
            return new ManyElementResolveState(state, this);
        }

        @Override
        public <T> T get(@NotNull Key<T> key) {
            Object value = this.myKey1.equals(key) ? this.myValue1 : (this.myKey2.equals(key) ? this.myValue2 : null);
            if (value == null && key instanceof KeyWithDefaultValue) {
                return (T)((KeyWithDefaultValue)key).getDefaultValue();
            }
            return (T)value;
        }
    }

    private static class OneElementResolveState
    extends ResolveState {
        @NotNull
        private final Key myKey;
        private final Object myValue;

        private OneElementResolveState(@NotNull Key key, Object value) {
            this.myKey = key;
            this.myValue = value;
        }

        @Override
        @NotNull
        public <T> ResolveState put(@NotNull Key<T> key, T value) {
            if (this.myKey.equals(key)) {
                return new OneElementResolveState(key, value);
            }
            return new TwoElementResolveState(this.myKey, this.myValue, key, value);
        }

        @Override
        @NotNull
        public ResolveState putAll(@NotNull ResolveState state) {
            return state.get(this.myKey) == null ? state.put(this.myKey, this.myValue) : state;
        }

        @Override
        public <T> T get(@NotNull Key<T> key) {
            Object value;
            Object object = value = this.myKey.equals(key) ? this.myValue : null;
            if (value == null && key instanceof KeyWithDefaultValue) {
                return (T)((KeyWithDefaultValue)key).getDefaultValue();
            }
            return (T)value;
        }
    }
}

