/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ReferenceRange {
    private ReferenceRange() {
    }

    @NotNull
    public static List<TextRange> getRanges(@NotNull PsiReference ref) {
        return ReferenceRange.getRanges((PsiSymbolReference)ref);
    }

    @ApiStatus.Experimental
    @NotNull
    public static List<TextRange> getRanges(@NotNull PsiSymbolReference ref) {
        if (ref instanceof MultiRangeReference) {
            return ((MultiRangeReference)ref).getRanges();
        }
        return Collections.singletonList(ref.getRangeInElement());
    }

    @NotNull
    public static List<TextRange> getAbsoluteRanges(@NotNull PsiReference ref) {
        return ReferenceRange.getAbsoluteRanges((PsiSymbolReference)ref);
    }

    @ApiStatus.Experimental
    @NotNull
    public static List<TextRange> getAbsoluteRanges(@NotNull PsiSymbolReference ref) {
        PsiElement elt = ref.getElement();
        List<TextRange> relativeRanges = ReferenceRange.getRanges(ref);
        ArrayList<TextRange> answer = new ArrayList<TextRange>(relativeRanges.size());
        int parentOffset = elt.getTextRange().getStartOffset();
        for (TextRange relativeRange : relativeRanges) {
            answer.add(relativeRange.shiftRight(parentOffset));
        }
        return answer;
    }

    public static TextRange getRange(@NotNull PsiReference ref) {
        if (ref instanceof MultiRangeReference) {
            List<TextRange> ranges2 = ((MultiRangeReference)ref).getRanges();
            return new TextRange(ranges2.get(0).getStartOffset(), ranges2.get(ranges2.size() - 1).getEndOffset());
        }
        return ref.getRangeInElement();
    }

    public static boolean containsOffsetInElement(@NotNull PsiReference ref, int offset) {
        return ReferenceRange.containsOffsetInElement((PsiSymbolReference)ref, offset);
    }

    @ApiStatus.Experimental
    public static boolean containsOffsetInElement(@NotNull PsiSymbolReference ref, int offset) {
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.containsOffset(offset)) continue;
                return true;
            }
            return false;
        }
        return ref.getRangeInElement().containsOffset(offset);
    }

    @ApiStatus.Experimental
    public static boolean containsRangeInElement(@NotNull PsiSymbolReference ref, @NotNull TextRange rangeInElement) {
        if (ref instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)ref).getRanges()) {
                if (!range.contains(rangeInElement)) continue;
                return true;
            }
            return false;
        }
        return ref.getRangeInElement().contains(rangeInElement);
    }
}

