/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.EventListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiDocumentManager {
    public abstract boolean isCommitted(@NotNull Document var1);

    public static PsiDocumentManager getInstance(@NotNull Project project) {
        return (PsiDocumentManager)project.getService(PsiDocumentManager.class);
    }

    @Nullable
    public abstract PsiFile getPsiFile(@NotNull Document var1);

    @Nullable
    public abstract PsiFile getCachedPsiFile(@NotNull Document var1);

    @Nullable
    public abstract Document getDocument(@NotNull PsiFile var1);

    @Nullable
    public abstract Document getCachedDocument(@NotNull PsiFile var1);

    public abstract void commitAllDocuments();

    public abstract boolean commitAllDocumentsUnderProgress();

    public abstract void performForCommittedDocument(@NotNull Document var1, @NotNull Runnable var2);

    public abstract void commitDocument(@NotNull Document var1);

    @NotNull
    public abstract CharSequence getLastCommittedText(@NotNull Document var1);

    public abstract long getLastCommittedStamp(@NotNull Document var1);

    @Nullable
    public abstract Document getLastCommittedDocument(@NotNull PsiFile var1);

    public abstract Document @NotNull [] getUncommittedDocuments();

    public abstract boolean isUncommited(@NotNull Document var1);

    public abstract boolean hasUncommitedDocuments();

    @ApiStatus.Experimental
    public boolean hasEventSystemEnabledUncommittedDocuments() {
        return this.hasUncommitedDocuments();
    }

    public abstract void commitAndRunReadAction(@NotNull Runnable var1);

    public abstract <T> T commitAndRunReadAction(@NotNull Computable<T> var1);

    public abstract void reparseFiles(@NotNull Collection<? extends VirtualFile> var1, boolean var2);

    @Deprecated
    public abstract void addListener(@NotNull Listener var1);

    @Deprecated
    public abstract void removeListener(@NotNull Listener var1);

    public abstract boolean isDocumentBlockedByPsi(@NotNull Document var1);

    public abstract void doPostponedOperationsAndUnblockDocument(@NotNull Document var1);

    public abstract boolean performWhenAllCommitted(@NotNull Runnable var1);

    public abstract void performLaterWhenAllCommitted(@NotNull Runnable var1);

    public abstract void performLaterWhenAllCommitted(@NotNull Runnable var1, ModalityState var2);

    public static interface Listener
    extends EventListener {
        public void documentCreated(@NotNull Document var1, @Nullable PsiFile var2);

        default public void fileCreated(@NotNull PsiFile file, @NotNull Document document) {
        }
    }
}

