/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.ide.ui.UISettings;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ToolWindowAnchor {
    @NotNull
    public static final ToolWindowAnchor TOP = new ToolWindowAnchor("top");
    @NotNull
    public static final ToolWindowAnchor LEFT = new ToolWindowAnchor("left");
    @NotNull
    public static final ToolWindowAnchor BOTTOM = new ToolWindowAnchor("bottom");
    @NotNull
    public static final ToolWindowAnchor RIGHT = new ToolWindowAnchor("right");
    @NotNull
    private final String myText;

    private ToolWindowAnchor(@NonNls @NotNull String text) {
        this.myText = text;
    }

    @NotNull
    public String toString() {
        return this.myText;
    }

    public boolean isHorizontal() {
        return this == TOP || this == BOTTOM;
    }

    @NotNull
    public static ToolWindowAnchor get(int swingOrientationConstant) {
        switch (swingOrientationConstant) {
            case 1: {
                return TOP;
            }
            case 3: {
                return BOTTOM;
            }
            case 2: {
                return LEFT;
            }
            case 4: {
                return RIGHT;
            }
        }
        throw new IllegalArgumentException("Unknown anchor constant: " + swingOrientationConstant);
    }

    public boolean isSplitVertically() {
        return this == LEFT && !UISettings.getInstance().getLeftHorizontalSplit() || this == RIGHT && !UISettings.getInstance().getRightHorizontalSplit();
    }

    @NotNull
    public static ToolWindowAnchor fromText(@NotNull String anchor) {
        switch (anchor) {
            case "top": {
                return TOP;
            }
            case "left": {
                return LEFT;
            }
            case "bottom": {
                return BOTTOM;
            }
            case "right": {
                return RIGHT;
            }
        }
        throw new IllegalArgumentException("Unknown anchor constant: " + anchor);
    }
}

