/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.contentAnnotation;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="VcsContentAnnotationSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class VcsContentAnnotationSettings
implements PersistentStateComponent<State> {
    public static final int ourMaxDays = 31;
    static final long ourAbsoluteLimit = TimeUnit.DAYS.toMillis(31L);
    private State myState = new State();

    public static VcsContentAnnotationSettings getInstance(Project project) {
        return ServiceManager.getService(project, VcsContentAnnotationSettings.class);
    }

    @Override
    public State getState() {
        return this.myState;
    }

    @Override
    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    public long getLimit() {
        return this.myState.myLimit;
    }

    public int getLimitDays() {
        return (int)TimeUnit.MILLISECONDS.toDays(this.myState.myLimit);
    }

    public void setLimit(int days) {
        this.myState.myLimit = TimeUnit.DAYS.toMillis(days);
    }

    public boolean isShow() {
        return this.myState.myShow1;
    }

    public void setShow(boolean value) {
        this.myState.myShow1 = value;
    }

    static final class State {
        public boolean myShow1;
        public long myLimit = ourAbsoluteLimit;

        State() {
        }
    }
}

