/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListModification;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeListManager
implements ChangeListModification {
    @NotNull
    public static ChangeListManager getInstance(@NotNull Project project) {
        return (ChangeListManager)project.getService(ChangeListManager.class);
    }

    public abstract void scheduleUpdate();

    @Deprecated
    public void scheduleUpdate(boolean updateUnversionedFiles) {
        this.scheduleUpdate();
    }

    public abstract void invokeAfterUpdate(@NotNull Runnable var1, @NotNull InvokeAfterUpdateMode var2, @Nullable String var3, @Nullable ModalityState var4);

    @Deprecated
    public abstract void invokeAfterUpdate(@NotNull Runnable var1, @NotNull InvokeAfterUpdateMode var2, @Nullable String var3, @Nullable Consumer<? super VcsDirtyScopeManager> var4, @Nullable ModalityState var5);

    public abstract int getChangeListsNumber();

    @NotNull
    public List<LocalChangeList> getChangeListsCopy() {
        return this.getChangeLists();
    }

    @NotNull
    public abstract List<LocalChangeList> getChangeLists();

    @NotNull
    public abstract Collection<Change> getAllChanges();

    @NotNull
    public abstract LocalChangeList getDefaultChangeList();

    @NotNull
    public abstract String getDefaultListName();

    @NotNull
    public abstract List<File> getAffectedPaths();

    @NotNull
    public abstract List<VirtualFile> getAffectedFiles();

    public abstract boolean isFileAffected(@NotNull VirtualFile var1);

    @Nullable
    public abstract LocalChangeList findChangeList(String var1);

    @Nullable
    public abstract LocalChangeList getChangeList(@Nullable String var1);

    @NotNull
    public abstract List<LocalChangeList> getChangeLists(@NotNull Change var1);

    @NotNull
    public abstract List<LocalChangeList> getChangeLists(@NotNull VirtualFile var1);

    @Nullable
    public abstract LocalChangeList getChangeList(@NotNull Change var1);

    @Nullable
    public abstract LocalChangeList getChangeList(@NotNull VirtualFile var1);

    @Nullable
    public abstract String getChangeListNameIfOnlyOne(Change[] var1);

    @Nullable
    public abstract Change getChange(@NotNull VirtualFile var1);

    @Nullable
    public abstract Change getChange(FilePath var1);

    @NotNull
    public abstract FileStatus getStatus(@NotNull VirtualFile var1);

    public abstract boolean isUnversioned(VirtualFile var1);

    @NotNull
    public abstract Collection<Change> getChangesIn(@NotNull VirtualFile var1);

    @NotNull
    public abstract Collection<Change> getChangesIn(@NotNull FilePath var1);

    @NotNull
    public abstract ThreeState haveChangesUnder(@NotNull VirtualFile var1);

    @Nullable
    public abstract AbstractVcs getVcsFor(@NotNull Change var1);

    public abstract void addChangeListListener(@NotNull ChangeListListener var1, @NotNull Disposable var2);

    public abstract void addChangeListListener(@NotNull ChangeListListener var1);

    public abstract void removeChangeListListener(@NotNull ChangeListListener var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public abstract void registerCommitExecutor(@NotNull CommitExecutor var1);

    @NotNull
    public abstract List<CommitExecutor> getRegisteredExecutors();

    public abstract void commitChanges(@NotNull LocalChangeList var1, @NotNull List<? extends Change> var2);

    public abstract void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList var1);

    public abstract void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList var1, boolean var2);

    @Deprecated
    public abstract IgnoredFileBean @NotNull [] getFilesToIgnore();

    public abstract boolean isIgnoredFile(@NotNull VirtualFile var1);

    public abstract boolean isIgnoredFile(@NotNull FilePath var1);

    @Deprecated
    public abstract void setFilesToIgnore(IgnoredFileBean ... var1);

    @Deprecated
    public abstract void addFilesToIgnore(IgnoredFileBean ... var1);

    @Deprecated
    public abstract void addDirectoryToIgnoreImplicitly(@NotNull String var1);

    @Deprecated
    public abstract void removeImplicitlyIgnoredDirectory(@NotNull String var1);

    @NotNull
    public abstract List<VirtualFile> getModifiedWithoutEditing();

    @Nullable
    public abstract String getSwitchedBranch(@NotNull VirtualFile var1);

    @Nullable
    public abstract String isFreezed();

    public abstract boolean isFreezedWithNotification(@Nls @Nullable String var1);

    @Deprecated
    public abstract void reopenFiles(@NotNull List<? extends FilePath> var1);
}

