/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowAllAffectedGenericAction
extends AnAction
implements DumbAware {
    private static final String ACTION_ID = "VcsHistory.ShowAllAffected";

    private ShowAllAffectedGenericAction() {
    }

    public static ShowAllAffectedGenericAction getInstance() {
        return (ShowAllAffectedGenericAction)ActionManager.getInstance().getAction(ACTION_ID);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        VcsKey vcsKey = e.getData(VcsDataKeys.VCS);
        if (vcsKey == null) {
            return;
        }
        VcsFileRevision revision = e.getData(VcsDataKeys.VCS_FILE_REVISION);
        VirtualFile revisionVirtualFile = e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        Boolean isNonLocal = e.getData(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION);
        if (revision != null && revisionVirtualFile != null) {
            ShowAllAffectedGenericAction.showSubmittedFiles(project, revision.getRevisionNumber(), revisionVirtualFile, vcsKey, revision.getChangedRepositoryPath(), Boolean.TRUE.equals(isNonLocal));
        }
    }

    public static void showSubmittedFiles(@NotNull Project project, @NotNull VcsRevisionNumber revision, @NotNull VirtualFile virtualFile2, @NotNull VcsKey vcsKey) {
        ShowAllAffectedGenericAction.showSubmittedFiles(project, revision, virtualFile2, vcsKey, null, false);
    }

    public static void showSubmittedFiles(@NotNull Project project, @NotNull VcsRevisionNumber revision, @NotNull VirtualFile virtualFile2, @NotNull VcsKey vcsKey, @Nullable RepositoryLocation location, boolean isNonLocal) {
        AbstractVcsHelper.getInstance(project).loadAndShowCommittedChangesDetails(project, revision, virtualFile2, vcsKey, location, isNonLocal);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getData(CommonDataKeys.PROJECT);
        VcsKey vcsKey = e.getData(VcsDataKeys.VCS);
        if (project == null || vcsKey == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Boolean isNonLocal = e.getData(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION);
        VirtualFile revisionVirtualFile = e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        boolean enabled = e.getData(VcsDataKeys.VCS_FILE_REVISION) != null && revisionVirtualFile != null;
        enabled = enabled && (!Boolean.TRUE.equals(isNonLocal) || ShowAllAffectedGenericAction.canPresentNonLocal(project, vcsKey, revisionVirtualFile));
        e.getPresentation().setEnabled(enabled);
    }

    private static boolean canPresentNonLocal(@NotNull Project project, @NotNull VcsKey key, @NotNull VirtualFile file) {
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance(project).findVcsByName(key.getName());
        if (vcs == null) {
            return false;
        }
        CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
        if (provider == null) {
            return false;
        }
        return provider.getForNonLocal(file) != null;
    }
}

