/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PlaceProvider;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsContext
extends PlaceProvider<String> {
    @Nullable
    public Project getProject();

    @Nullable
    public VirtualFile getSelectedFile();

    public VirtualFile @NotNull [] getSelectedFiles();

    @NotNull
    default public Stream<VirtualFile> getSelectedFilesStream() {
        return Arrays.stream(this.getSelectedFiles());
    }

    @Deprecated
    @NotNull
    default public List<VirtualFile> getSelectedUnversionedFiles() {
        return ContainerUtil.mapNotNull(this.getSelectedUnversionedFilePaths(), FilePath::getVirtualFile);
    }

    @NotNull
    default public List<FilePath> getSelectedUnversionedFilePaths() {
        return Collections.emptyList();
    }

    public Editor getEditor();

    public Collection<VirtualFile> getSelectedFilesCollection();

    public File[] getSelectedIOFiles();

    public int getModifiers();

    public Refreshable getRefreshableDialog();

    public File getSelectedIOFile();

    public FilePath @NotNull [] getSelectedFilePaths();

    @NotNull
    default public Stream<FilePath> getSelectedFilePathsStream() {
        return Arrays.stream(this.getSelectedFilePaths());
    }

    @Nullable
    public FilePath getSelectedFilePath();

    public ChangeList @Nullable [] getSelectedChangeLists();

    public Change @Nullable [] getSelectedChanges();

    public String getActionName();
}

