/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup.util;

import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import com.intellij.openapi.util.NlsContexts;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseListPopupStep<T>
extends BaseStep<T>
implements ListPopupStep<T> {
    private String myTitle;
    private List<T> myValues;
    private List<? extends Icon> myIcons;
    private int myDefaultOptionIndex = -1;

    @SafeVarargs
    public BaseListPopupStep(@NlsContexts.PopupTitle @Nullable String title, T ... values) {
        this(title, values, new Icon[0]);
    }

    public BaseListPopupStep(@NlsContexts.PopupTitle @Nullable String title, List<? extends T> values) {
        this(title, values, new ArrayList());
    }

    public BaseListPopupStep(@NlsContexts.PopupTitle @Nullable String title, T[] values, Icon[] icons) {
        this(title, Arrays.asList(values), Arrays.asList(icons));
    }

    public BaseListPopupStep(@NlsContexts.PopupTitle @Nullable String title, @NotNull List<? extends T> aValues, Icon aSameIcon) {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (int i = 0; i < aValues.size(); ++i) {
            icons.add(aSameIcon);
        }
        this.init(title, aValues, icons);
    }

    public BaseListPopupStep(@NlsContexts.PopupTitle @Nullable String title, @NotNull List<? extends T> values, List<? extends Icon> icons) {
        this.init(title, values, icons);
    }

    protected BaseListPopupStep() {
    }

    protected final void init(@NlsContexts.PopupTitle @Nullable String title, @NotNull List<? extends T> values, @Nullable List<? extends Icon> icons) {
        this.myTitle = title;
        this.myValues = new ArrayList<T>(values);
        this.myIcons = icons;
    }

    @Nullable
    public final String getTitle() {
        return this.myTitle;
    }

    @Override
    @NotNull
    public final List<T> getValues() {
        return this.myValues;
    }

    @Nullable
    public PopupStep onChosen(T selectedValue, boolean finalChoice) {
        return FINAL_CHOICE;
    }

    @Override
    public Icon getIconFor(T value) {
        int index = this.myValues.indexOf(value);
        if (index != -1 && this.myIcons != null && index < this.myIcons.size()) {
            return this.myIcons.get(index);
        }
        return null;
    }

    @Nullable
    public Color getBackgroundFor(T value) {
        return null;
    }

    @Nullable
    public Color getForegroundFor(T value) {
        return null;
    }

    @Override
    @NotNull
    public String getTextFor(T value) {
        return value.toString();
    }

    @Override
    @Nullable
    public ListSeparator getSeparatorAbove(T value) {
        return null;
    }

    @Override
    public boolean isSelectable(T value) {
        return true;
    }

    public boolean hasSubstep(T selectedValue) {
        return false;
    }

    public void canceled() {
    }

    public void setDefaultOptionIndex(int aDefaultOptionIndex) {
        this.myDefaultOptionIndex = aDefaultOptionIndex;
    }

    @Override
    public int getDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }
}

