/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.cellvalidators;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.cellvalidators.TableCellValidator;
import com.intellij.ui.CellRendererPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ValidatingTableCellRendererWrapper
extends CellRendererPanel
implements TableCellRenderer {
    public static final String CELL_VALIDATION_PROPERTY = "CellRenderer.validationInfo";
    private final TableCellRenderer delegate;
    private final JLabel iconLabel = new JLabel();
    private Supplier<? extends Dimension> editorSizeSupplier = () -> JBUI.emptySize();
    private TableCellValidator cellValidator;

    @ApiStatus.Experimental
    public ValidatingTableCellRendererWrapper(TableCellRenderer delegate) {
        this.delegate = delegate;
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.iconLabel, "East");
        this.iconLabel.setOpaque(false);
        this.setName("Table.cellRenderer");
    }

    @ApiStatus.Experimental
    public ValidatingTableCellRendererWrapper bindToEditorSize(@NotNull Supplier<? extends Dimension> editorSizeSupplier) {
        this.editorSizeSupplier = editorSizeSupplier;
        return this;
    }

    @ApiStatus.Experimental
    public ValidatingTableCellRendererWrapper withCellValidator(@NotNull TableCellValidator cellValidator) {
        this.cellValidator = cellValidator;
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = Math.max(size.height, this.editorSizeSupplier.get().height);
        return size;
    }

    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent delegateRenderer = (JComponent)this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.cellValidator != null) {
            ValidationInfo result = this.cellValidator.validate(value, row, column);
            this.iconLabel.setIcon(result == null ? null : (result.warning ? AllIcons.General.BalloonWarning : AllIcons.General.BalloonError));
            this.iconLabel.setBorder(result == null ? null : ValidatingTableCellRendererWrapper.iconBorder());
            this.putClientProperty(CELL_VALIDATION_PROPERTY, result);
        }
        this.add((Component)delegateRenderer, "Center");
        this.setBorder(delegateRenderer.getBorder());
        delegateRenderer.setBorder(null);
        this.setBackground(delegateRenderer.getBackground());
        return this;
    }

    private static Border iconBorder() {
        return JBUI.Borders.emptyRight((int)(UIUtil.isUnderWin10LookAndFeel() ? 4 : 3));
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }
}

