/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.cellvalidators;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class CellComponentProvider<C extends JComponent> {
    @NotNull
    protected final C owner;

    public CellComponentProvider(@NotNull C owner) {
        this.owner = owner;
    }

    @NotNull
    public final C getOwner() {
        return this.owner;
    }

    @Nullable
    public abstract JComponent getCellRendererComponent(@NotNull MouseEvent var1);

    @NotNull
    public abstract Rectangle getCellRect(@NotNull MouseEvent var1);

    abstract boolean isEditing(@NotNull MouseEvent var1);

    abstract boolean isEditingStarted(@NotNull PropertyChangeEvent var1);

    public static CellComponentProvider<JTable> forTable(JTable table) {
        return new TableProvider(table);
    }

    public static class TableProvider
    extends CellComponentProvider<JTable> {
        protected TableProvider(@NotNull JTable owner) {
            super(owner);
        }

        @Override
        @Nullable
        public JComponent getCellRendererComponent(@NotNull MouseEvent e) {
            Point p = e.getPoint();
            int column = ((JTable)this.owner).columnAtPoint(p);
            int row = ((JTable)this.owner).rowAtPoint(p);
            if (column != -1 && row != -1) {
                TableCellRenderer renderer = ((JTable)this.owner).getCellRenderer(row, column);
                return (JComponent)((JTable)this.owner).prepareRenderer(renderer, row, column);
            }
            return null;
        }

        @Override
        @NotNull
        public Rectangle getCellRect(@NotNull MouseEvent e) {
            Point p = e.getPoint();
            return ((JTable)this.owner).getCellRect(((JTable)this.owner).rowAtPoint(p), ((JTable)this.owner).columnAtPoint(p), false);
        }

        @Override
        public boolean isEditing(@NotNull MouseEvent e) {
            Point p = e.getPoint();
            return ((JTable)this.owner).rowAtPoint(p) == ((JTable)this.owner).getEditingRow() && ((JTable)this.owner).columnAtPoint(p) == ((JTable)this.owner).getEditingColumn();
        }

        @Override
        public boolean isEditingStarted(@NotNull PropertyChangeEvent e) {
            return "tableCellEditor".equals(e.getPropertyName()) && e.getNewValue() != null;
        }
    }
}

