/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultModulesProvider
implements ModulesProvider {
    private final Project myProject;

    @NotNull
    public static ModulesProvider createForProject(@Nullable Project project) {
        return project == null ? EMPTY_MODULES_PROVIDER : new DefaultModulesProvider(project);
    }

    public DefaultModulesProvider(Project project) {
        this.myProject = project;
    }

    @Override
    public Module @NotNull [] getModules() {
        return ModuleManager.getInstance(this.myProject).getModules();
    }

    @Override
    public Module getModule(@NotNull String name) {
        return ModuleManager.getInstance(this.myProject).findModuleByName(name);
    }

    @Override
    public ModuleRootModel getRootModel(@NotNull Module module) {
        return ModuleRootManager.getInstance(module);
    }

    @Override
    @NotNull
    public FacetModel getFacetModel(@NotNull Module module) {
        return FacetManager.getInstance(module);
    }
}

