/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathsList;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public abstract class OrderEnumerator {
    @NotNull
    public abstract OrderEnumerator productionOnly();

    @NotNull
    public abstract OrderEnumerator compileOnly();

    @NotNull
    public abstract OrderEnumerator runtimeOnly();

    @NotNull
    public abstract OrderEnumerator withoutSdk();

    @NotNull
    public abstract OrderEnumerator withoutLibraries();

    @NotNull
    public abstract OrderEnumerator withoutDepModules();

    @NotNull
    public abstract OrderEnumerator withoutModuleSourceEntries();

    @NotNull
    public OrderEnumerator librariesOnly() {
        return this.withoutSdk().withoutDepModules().withoutModuleSourceEntries();
    }

    @NotNull
    public OrderEnumerator sdkOnly() {
        return this.withoutDepModules().withoutLibraries().withoutModuleSourceEntries();
    }

    public VirtualFile @NotNull [] getAllLibrariesAndSdkClassesRoots() {
        return this.withoutModuleSourceEntries().withoutDepModules().recursively().exportedOnly().classes().usingCache().getRoots();
    }

    public VirtualFile @NotNull [] getAllSourceRoots() {
        return this.recursively().exportedOnly().sources().usingCache().getRoots();
    }

    @NotNull
    public abstract OrderEnumerator recursively();

    @NotNull
    public abstract OrderEnumerator exportedOnly();

    @NotNull
    public abstract OrderEnumerator satisfying(@NotNull Condition<? super OrderEntry> var1);

    @NotNull
    public abstract OrderEnumerator using(@NotNull RootModelProvider var1);

    public abstract boolean shouldRecurse(@NotNull ModuleOrderEntry var1, @NotNull List<? extends OrderEnumerationHandler> var2);

    @NotNull
    public abstract OrderRootsEnumerator classes();

    @NotNull
    public abstract OrderRootsEnumerator sources();

    @NotNull
    public abstract OrderRootsEnumerator roots(@NotNull OrderRootType var1);

    @NotNull
    public abstract OrderRootsEnumerator roots(@NotNull NotNullFunction<? super OrderEntry, ? extends OrderRootType> var1);

    public VirtualFile @NotNull [] getClassesRoots() {
        return this.classes().getRoots();
    }

    public VirtualFile @NotNull [] getSourceRoots() {
        return this.sources().getRoots();
    }

    @NotNull
    public PathsList getPathsList() {
        return this.classes().getPathsList();
    }

    @NotNull
    public PathsList getSourcePathsList() {
        return this.sources().getPathsList();
    }

    public abstract void forEach(@NotNull Processor<? super OrderEntry> var1);

    public abstract void forEachLibrary(@NotNull Processor<? super Library> var1);

    public abstract void forEachModule(@NotNull Processor<? super Module> var1);

    public abstract <R> R process(@NotNull RootPolicy<R> var1, R var2);

    @NotNull
    public static OrderEnumerator orderEntries(@NotNull Module module) {
        return ModuleRootManager.getInstance(module).orderEntries();
    }

    @NotNull
    public static OrderEnumerator orderEntries(@NotNull Project project) {
        return ProjectRootManager.getInstance(project).orderEntries();
    }
}

