/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SdkTypeId {
    @NotNull
    public String getName();

    @Nullable
    public String getVersionString(@NotNull Sdk var1);

    public void saveAdditionalData(@NotNull SdkAdditionalData var1, @NotNull Element var2);

    @Nullable
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk var1, @NotNull Element var2);

    default public boolean isLocalSdk(@NotNull Sdk sdk) {
        return true;
    }

    @NotNull
    default public Comparator<Sdk> versionComparator() {
        Comparator<String> versionStringComparator = this.versionStringComparator();
        return (sdk1, sdk2) -> {
            if (!1.$assertionsDisabled && sdk1.getSdkType() != this) {
                throw new AssertionError(sdk1);
            }
            if (!1.$assertionsDisabled && sdk2.getSdkType() != this) {
                throw new AssertionError(sdk2);
            }
            return versionStringComparator.compare(sdk1.getVersionString(), sdk2.getVersionString());
        };
    }

    @NotNull
    default public Comparator<String> versionStringComparator() {
        return (v1, v2) -> StringUtil.compareVersionNumbers((String)v1, (String)v2);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

